/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.catalog.DWTypeCatalog;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataUtilsTest {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    @Test
    void testLabelAnnotation() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"label\")\nannotation Label(value: String)\n\ntype MyObject = {\n    fieldWithLabel: @Label(value = \"The Label\") String\n}\nvar v: MyObject = {\n    fieldWithLabel: \"asd\"\n}\n---\nv";
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)this.dataWeaveEngine.inferTypeOf(script).get()).resolveType();
        DWType field = DWTypeUtils.requireFieldByName((ObjectType)weaveType, (String)"fieldWithLabel").getValue();
        String label = (String)MetadataUtils.getLabel((DWType)field).orElseThrow();
        Assertions.assertEquals((Object)"The Label", (Object)label);
    }

    @Test
    void testHelpTextAnnotation() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"helpText\")\nannotation HelpText(value: String)\n\ntype MyObject = {\n    fieldWithHelpText: @HelpText(value = \"The Help Text\") String\n}\nvar v: MyObject = {\n    fieldWithHelpText: \"asd\"\n}\n---\nv";
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)this.dataWeaveEngine.inferTypeOf(script).get()).resolveType();
        DWType field = DWTypeUtils.requireFieldByName((ObjectType)weaveType, (String)"fieldWithHelpText").getValue();
        String helpText = (String)MetadataUtils.getHelpText((DWType)field).orElseThrow();
        Assertions.assertEquals((Object)"The Help Text", (Object)helpText);
    }

    @Test
    void testDefaultValueAnnotation() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"defaultValue\")\nannotation DefaultValue(value: String)\n\ntype MyObject = {\n    fieldWithDefaultValue: @DefaultValue(value = \"The Default Value\") String\n}\nvar v: MyObject = {\n    fieldWithDefaultValue: \"asd\"\n}\n---\nv";
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)this.dataWeaveEngine.inferTypeOf(script).get()).resolveType();
        DWType field = DWTypeUtils.requireFieldByName((ObjectType)weaveType, (String)"fieldWithDefaultValue").getValue();
        String defaultValue = (String)MetadataUtils.getDefaultValue((DWType)field).orElseThrow();
        Assertions.assertEquals((Object)"The Default Value", (Object)defaultValue);
    }

    @Test
    void objectPropertyMetadataContainsReferencedTypeMetadata() {
        DWTypeCatalog catalog = DefaultDWTypeCatalog.loader().fromCatalog("%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"description\")\nannotation Description(value: String)\n\ntype LWDate = String <~ { format: \"date\" }\n\ntype anObject = {\n  aDate: @Description(value = \"Here goes a date\") LWDate\n}\n");
        DWType type = (DWType)catalog.getType("anObject").orElseThrow();
        DWType propertyValue = ((KeyValuePairType)TypeUtils.getObjectProperty((DWType)type, (String)"aDate").get()).getValue();
        Assertions.assertEquals((int)2, (int)propertyValue.getTypeMetadata().length);
        Assertions.assertEquals((Object)"description", (Object)propertyValue.getTypeMetadata()[0].getName());
        Assertions.assertEquals((Object)"format", (Object)propertyValue.getTypeMetadata()[1].getName());
    }

    @Test
    void testHiddenAnnotation() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"hidden\")\nannotation Hidden(value: {} = {})\n\ntype MyObject = {\n    fieldHidden: @Hidden() String\n}\nvar v: MyObject = {\n    fieldHidden: \"f\"\n}\n---\nv";
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)this.dataWeaveEngine.inferTypeOf(script).get()).resolveType();
        DWType field = DWTypeUtils.requireFieldByName((ObjectType)weaveType, (String)"fieldHidden").getValue();
        Assertions.assertTrue((boolean)MetadataUtils.isHidden((DWType)field));
    }

    @Test
    void testTemplateAnnotation() {
        String script = "%dw 2.9\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"template\")\nannotation Template(value: String)\n\ntype MyObject = {\n    fieldWithTemplate: @Template(value = \"MyTemplate\") String\n}\nvar v: MyObject = {\n    fieldWithTemplate: \"f\"\n}\n---\nv";
        ObjectType weaveType = (ObjectType)((SimpleReferenceType)this.dataWeaveEngine.inferTypeOf(script).get()).resolveType();
        DWType field = DWTypeUtils.requireFieldByName((ObjectType)weaveType, (String)"fieldWithTemplate").getValue();
        String template = (String)MetadataUtils.getTemplate((DWType)field).orElseThrow();
        Assertions.assertEquals((Object)"MyTemplate", (Object)template);
    }
}

