/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.weave.v2.model.service.LoggingService;

public class LWLogger {
    private static LoggingService loggingService = new LocalLoggingService();
    private static final String LW_LOGGER_IDENTIFIER = "LW - ";

    private LWLogger() {
        throw new UnsupportedOperationException();
    }

    public static void set(LoggingService iLogger) {
        Objects.requireNonNull(iLogger, "logger");
        loggingService = iLogger;
    }

    public static void logInfo(String msg) {
        if (loggingService.isInfoEnabled()) {
            loggingService.logInfo(LW_LOGGER_IDENTIFIER + msg);
        }
    }

    public static void logWarn(String msg) {
        loggingService.logWarn(LW_LOGGER_IDENTIFIER + msg);
    }

    public static void logError(String msg) {
        loggingService.logError(LW_LOGGER_IDENTIFIER + msg);
    }

    public static void logDebug(String msg) {
        if (loggingService.isDebugEnabled()) {
            loggingService.logDebug(LW_LOGGER_IDENTIFIER + msg);
        }
    }

    private static class LocalLoggingService
    implements LoggingService {
        private final Logger logger = Logger.getLogger(LocalLoggingService.class.getName());

        private LocalLoggingService() {
        }

        private Logger logger() {
            return this.logger;
        }

        public boolean isDebugEnabled() {
            return this.logger().isLoggable(Level.CONFIG);
        }

        public void logDebug(String msg) {
            this.logger().log(Level.CONFIG, msg);
        }

        public boolean isInfoEnabled() {
            return this.logger().isLoggable(Level.INFO);
        }

        public void logInfo(String msg) {
            this.logger().log(Level.INFO, msg);
        }

        public void logError(String msg) {
            this.logger().log(Level.SEVERE, msg);
        }

        public void logWarn(String msg) {
            this.logger().log(Level.WARNING, msg);
        }
    }
}

