/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.linkweave.api.model.Discriminator;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class MetadataUtils {
    private MetadataUtils() {
    }

    public static Optional<DWMetadata> getMetadata(DWType weaveType, String key) {
        Objects.requireNonNull(weaveType, "weaveType");
        Objects.requireNonNull(key, "key");
        if (!(weaveType instanceof KeyValuePairType)) {
            return MetadataUtils.reallyGetMetadata(weaveType, key);
        }
        KeyValuePairType kv = (KeyValuePairType)weaveType;
        List values = Stream.of(kv, kv.getKey(), kv.getValue()).map(t -> MetadataUtils.reallyGetMetadata(t, key)).flatMap(Optional::stream).toList();
        return switch (values.size()) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of((DWMetadata)values.get(0));
            default -> throw new IllegalStateException("Conflicting values in a field metadata with key '" + key + "' (those values are: " + String.valueOf(values) + "), at " + String.valueOf(weaveType.getLocation()));
        };
    }

    private static Optional<DWMetadata> getMetadata(DWType weaveType, MetadataKey metadataKey) {
        return MetadataUtils.getMetadata(weaveType, metadataKey.getKey());
    }

    private static Optional<DWMetadata> reallyGetMetadata(DWType weaveType, String key) {
        return Stream.of(weaveType.getTypeMetadata()).filter(metadata -> key.equals(metadata.getName())).findFirst();
    }

    public static Optional<ProviderReference> getMetadataProvider(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.METADATA_PROVIDER).map(metadata -> MetadataUtils.createProviderReference(metadata.getValue(), "The 'metadataProvider' metadata"));
    }

    public static Optional<ProviderReference> getValueProvider(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.VALUE_PROVIDER).map(metadata -> MetadataUtils.createProviderReference(metadata.getValue(), "The 'value provider' metadata"));
    }

    private static ProviderReference createProviderReference(DWMetadataValue value, String what) {
        List<KeyValuePairMetadataValue> vpData = MetadataValueUtils.asProperties(value, what);
        String vpName = MetadataValueUtils.requireStringProperty(vpData, "name");
        List<ProviderArgument> arguments = MetadataUtils.getProviderArguments(what, vpData);
        return new ProviderReference(vpName, arguments);
    }

    private static List<ProviderArgument> getProviderArguments(String what, List<KeyValuePairMetadataValue> vpData) {
        return MetadataValueUtils.getProperty(vpData, "arguments").map(args -> MetadataValueUtils.asProperties(args, what + " arguments ").stream().map(kv -> new ProviderArgument(ObjectFieldSelector.create(kv.getKey()), TypeReferenceExpression.create(MetadataValueUtils.asString(kv.getValue(), what + " argument for '" + kv.getKey() + "'")))).toList()).orElse(Collections.emptyList());
    }

    public static ProviderReference requireMetadataProvider(DWType weaveType) {
        return MetadataUtils.getMetadataProvider(weaveType).orElseThrow();
    }

    public static ProviderReference requireValueProvider(DWType weaveType) {
        return MetadataUtils.getValueProvider(weaveType).orElseThrow();
    }

    public static Optional<Map<String, TypeReferenceExpression>> getBindings(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.WITH).map(metadata -> {
            List<KeyValuePairMetadataValue> props = MetadataValueUtils.asProperties(metadata.getValue(), "The 'with' metadata");
            return props.stream().collect(Collectors.toMap(KeyValuePairMetadataValue::getKey, kv -> TypeReferenceExpression.create(MetadataValueUtils.asString(kv.getValue(), "A binding for '" + kv.getKey() + "' in the 'with' metadata"))));
        });
    }

    public static Optional<Set<String>> getSemanticTerms(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.SEMANTIC_TERMS).map(metadata -> MetadataValueUtils.asSet(metadata.getValue(), "The 'semanticTerms' metadata"));
    }

    public static Set<String> requireSemanticTerms(DWType weaveType) {
        return MetadataUtils.getSemanticTerms(weaveType).orElseThrow();
    }

    @Deprecated(forRemoval=true)
    public static Optional<String> getMetadataDescription(DWType weaveType) {
        return MetadataUtils.getDescription(weaveType);
    }

    public static Optional<String> getDescription(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.DESCRIPTION).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'description' metadata"));
    }

    public static String requireDescription(DWType weaveType) {
        return MetadataUtils.getDescription(weaveType).orElseThrow();
    }

    public static Optional<String> getLabel(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.LABEL).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'label' metadata"));
    }

    public static String requireLabel(DWType weaveType) {
        return MetadataUtils.getLabel(weaveType).orElseThrow();
    }

    public static Optional<String> getHelpText(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.HELP_TEXT).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'help text' metadata"));
    }

    public static Optional<String> getFormat(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.FORMAT).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'format' metadata"));
    }

    public static Optional<Integer> getMinSize(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.MIN_SIZE).map(metadata -> MetadataValueUtils.asInteger(metadata.getValue()));
    }

    public static Optional<Integer> getMaxSize(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.MAX_SIZE).map(metadata -> MetadataValueUtils.asInteger(metadata.getValue()));
    }

    public static Optional<String> getDefaultValue(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.DEFAULT_VALUE).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'default value' metadata"));
    }

    public static Optional<String> getTemplate(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.TEMPLATE).map(metadata -> MetadataValueUtils.asString(metadata.getValue(), "The 'template' metadata"));
    }

    public static String requireFormat(DWType weaveType) {
        return MetadataUtils.getFormat(weaveType).orElseThrow();
    }

    public static Optional<String> getTypeId(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.TYPE_ID).map(DWMetadata::getValue).map(LiteralMetadataValue.class::cast).map(LiteralMetadataValue::getValue);
    }

    public static String requireTypeId(DWType weaveType) {
        return MetadataUtils.getTypeId(weaveType).orElseThrow();
    }

    public static Optional<List<Object>> getEnumValues(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.ENUM_VALUES).map(DWMetadata::getValue).map(ArrayMetadataValue.class::cast).map(ArrayMetadataValue::getElements).map(el -> Stream.of(el).map(LiteralMetadataValue.class::cast).map(v -> {
            String simpleName = v.getType().getClass().getSimpleName();
            if (simpleName.contains("StringType")) {
                return v.getValue();
            }
            if (simpleName.contains("NumberType")) {
                return Integer.valueOf(v.getValue());
            }
            if (simpleName.contains("BooleanType")) {
                return Boolean.valueOf(v.getValue());
            }
            return v.getValue();
        }).toList());
    }

    public static List<Object> requireEnumValues(DWType weaveType) {
        return MetadataUtils.getEnumValues(weaveType).orElseThrow();
    }

    public static Optional<List<String>> getEnumLabels(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.ENUM_LABELS).map(DWMetadata::getValue).map(ArrayMetadataValue.class::cast).map(ArrayMetadataValue::getElements).map(el -> Stream.of(el).map(LiteralMetadataValue.class::cast).map(LiteralMetadataValue::getValue).toList());
    }

    public static Optional<Discriminator> getDiscriminator(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.DISCRIMINATOR).map(metadata -> MetadataUtils.createDiscriminator(metadata.getValue(), weaveType));
    }

    public static Discriminator createDiscriminator(DWMetadataValue value, DWType weaveType) {
        DWType dWType = TypeUtils.resolveReferenceType(weaveType);
        if (!(dWType instanceof UnionType)) {
            throw new IllegalStateException("WeaveType with Discriminator annotation should be an UnionType");
        }
        UnionType unionType = (UnionType)dWType;
        List<KeyValuePairMetadataValue> data = MetadataValueUtils.asProperties(value);
        String key = MetadataValueUtils.requireStringProperty(data, "key");
        String defaultSelection = MetadataValueUtils.getStringProperty(data, "defaultSelection").orElse(null);
        return new Discriminator(key, defaultSelection, MetadataUtils.getDiscriminatorValues(unionType, key));
    }

    private static List<ProvidedValue> getDiscriminatorValues(UnionType weaveType, String key) {
        return Arrays.stream(weaveType.unionOf()).map(wt -> TypeUtils.getObjectProperty(wt, key)).map(kv -> ((KeyValuePairType)kv.orElseThrow(() -> new IllegalStateException("Union member does not contains the field '" + key + "', which is a discriminator"))).getValue()).map(StringType.class::cast).map(stringType -> {
            String value = (String)stringType.getValue().orElseThrow(() -> new IllegalStateException("A union member has an empty '" + key + "', but it's a discriminator"));
            return new ProvidedValue(value, MetadataUtils.getLabel((DWType)stringType).orElse(value), null);
        }).toList();
    }

    public static boolean isHidden(DWType weaveType) {
        return MetadataUtils.getMetadata(weaveType, MetadataKey.HIDDEN).isPresent();
    }
}

