/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.provider;

import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public abstract class ProviderModel
extends Model {
    protected final String name;
    protected final TypeModel inputType;
    protected final TypeModel errorOutputType;

    protected ProviderModel(String name, TypeModel inputType, TypeModel errorOutputType, @Nullable String modelReference) {
        super(modelReference);
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.inputType = inputType;
        this.errorOutputType = errorOutputType;
    }

    public String getName() {
        return this.name;
    }

    public TypeModel getInputType() {
        return this.inputType;
    }

    public TypeModel getErrorOutputType() {
        return this.errorOutputType;
    }

    public static abstract class ProviderBuilder<M extends ProviderModel, T extends ProviderBuilder<M, T>>
    extends Model.Builder<M, T> {
        protected @Nullable String name;
        protected @Nullable TypeModel inputType;
        protected @Nullable TypeModel errorOutputType;

        public T name(String name) {
            this.name = Objects.requireNonNull(name);
            return (T)((ProviderBuilder)this.getThis());
        }

        public T inputType(TypeModel parameters) {
            this.inputType = Objects.requireNonNull(parameters);
            return (T)((ProviderBuilder)this.getThis());
        }

        public T errorOutputType(TypeModel errorOutputType) {
            this.errorOutputType = Objects.requireNonNull(errorOutputType);
            return (T)((ProviderBuilder)this.getThis());
        }
    }
}

