/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ImplicitAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2PasswordAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.value.Holder;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class LinkWeaveModelLoader001Test
extends AbstractConnectivityModelTest {
    @Test
    void loadsConnectorModel() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("test001::Connector");
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector"));
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"DataWeaveExtension"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Data Weave Extension"));
        Assertions.assertNull((Object)connectorModel.getDescription());
        MatcherAssert.assertThat(connectorModel.getConnectionProviders(), (Matcher)IsCollectionWithSize.hasSize((int)6));
        LinkWeaveModelLoader001Test.assertBasicAuthConnection(connectorModel.getConnectionProviders().get(0));
        LinkWeaveModelLoader001Test.assertApiKeyConnection(connectorModel.getConnectionProviders().get(1));
        LinkWeaveModelLoader001Test.assertOAuth2AuthCodeConnection(connectorModel.getConnectionProviders().get(2));
        LinkWeaveModelLoader001Test.assertOAuth2ClientCredentialsConnection(connectorModel.getConnectionProviders().get(3));
        LinkWeaveModelLoader001Test.assertOAuth2ImplicitConnection(connectorModel.getConnectionProviders().get(4));
        LinkWeaveModelLoader001Test.assertOAuth2PasswordConnection(connectorModel.getConnectionProviders().get(5));
        LinkWeaveModelLoader001Test.assertTestConnection(connectorModel.getTestConnection());
        MatcherAssert.assertThat(connectorModel.getValueProviders(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        LinkWeaveModelLoader001Test.assertAccountsValueProvider(connectorModel.getValueProviders().get(0), "test001::Connector::connector.valueProviders.accountsValueProvider");
        this.assertAccountsPaginatedValueProvider(connectorModel.getValueProviders().get(1), "test001::Connector::connector.valueProviders.accountsPaginatedValueProvider");
        LinkWeaveModelLoader001Test.assertUsersValueProvider(connectorModel.getValueProviders().get(2), "test001::Connector::connector.valueProviders.usersValueProvider");
        MatcherAssert.assertThat(connectorModel.getMetadataProviders(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        LinkWeaveModelLoader001Test.assertMetadataProvider(connectorModel.getMetadataProviders().get(0), "test001::Connector::connector.metadataProviders.metadataProvider");
        MatcherAssert.assertThat(connectorModel.getOperations(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        LinkWeaveModelLoader001Test.assertUpdateAccountByIdOperation(connectorModel.getOperations().get(0), "test001::Connector::connector.operations.updateAccountById");
        LinkWeaveModelLoader001Test.assertGetMessagesOperation(connectorModel.getOperations().get(1), "test001::Connector::connector.operations.getMessages");
        LinkWeaveModelLoader001Test.assertGetAccountsOperation(connectorModel.getOperations().get(2), "test001::Connector::connector.operations.getAccounts");
        this.assertTestFailuresOperation(connectorModel.getOperations().get(3), "test001::Connector::connector.operations.testFailures");
        MatcherAssert.assertThat(connectorModel.getTriggers(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        LinkWeaveModelLoader001Test.assertGetUsersTrigger(connectorModel.getTriggers().get(0), "test001::Connector::connector.triggers.getUsersTrigger");
        LinkWeaveModelLoader001Test.assertGetUsersPaginatedTrigger(connectorModel.getTriggers().get(1), "test001::Connector::connector.triggers.getUsersTriggerPaginated");
    }

    private static void assertTestConnection(TestConnectionModel testConnection) {
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.testConnection"));
    }

    private static void assertApiKeyConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.apiKeyAuth"));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> props = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(props, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("apiKey", StringType.class, true)}));
        final Holder apiKeyHttpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(new AuthenticationTypeVisitor(){

            public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
                throw new IllegalStateException("Should not be a generic HttpAuthenticationType");
            }

            public void visitApiKeyHttpAuthenticationType(ApiKeyHttpAuthenticationType apiKeyHttpAuthenticationType) {
                apiKeyHttpAuthenticationTypeHolder.setValue(apiKeyHttpAuthenticationType);
            }
        });
        ApiKeyHttpAuthenticationType apiKeyHttpAuthenticationType = (ApiKeyHttpAuthenticationType)apiKeyHttpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)apiKeyHttpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.apiKey));
        MatcherAssert.assertThat((Object)apiKeyHttpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)apiKeyHttpAuthenticationType.getIn(), (Matcher)Matchers.equalTo((Object)ApiKeyHttpAuthenticationType.In.header));
        MatcherAssert.assertThat((Object)apiKeyHttpAuthenticationType.getName(), (Matcher)Matchers.equalTo((Object)"X-API-KEY"));
    }

    private static void assertOAuth2AuthCodeConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.\"oauth2AuthCode\""));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("accessToken", StringType.class, true)}));
        final Holder OAuthHttpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(new AuthenticationTypeVisitor(){

            public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
                throw new IllegalStateException("Should not be a generic HttpAuthenticationType");
            }

            public void visitOAuth2HttpAuthenticationType(OAuth2AuthenticationType oAuthHttpAuthenticationType) {
                OAuthHttpAuthenticationTypeHolder.setValue(oAuthHttpAuthenticationType);
            }
        });
        OAuth2AuthCodeAuthenticationType oAuthHttpAuthenticationType = (OAuth2AuthCodeAuthenticationType)OAuthHttpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getSubType().get()), (Matcher)Matchers.equalTo((Object)OAuth2AuthenticationType.GrantType.authorizationCode.toString()));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getTokenUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getAuthorizationUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/authorize"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getScopes().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getScopes().get(0)), (Matcher)Matchers.equalTo((Object)"test"));
    }

    private static void assertOAuth2ClientCredentialsConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.\"oauth2ClientCredentials\""));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("accessToken", StringType.class, true)}));
        final Holder OAuthHttpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(new AuthenticationTypeVisitor(){

            public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
                throw new IllegalStateException("Should not be a generic HttpAuthenticationType");
            }

            public void visitOAuth2HttpAuthenticationType(OAuth2AuthenticationType oAuthHttpAuthenticationType) {
                OAuthHttpAuthenticationTypeHolder.setValue(oAuthHttpAuthenticationType);
            }
        });
        OAuth2ClientCredentialsAuthenticationType oAuthHttpAuthenticationType = (OAuth2ClientCredentialsAuthenticationType)OAuthHttpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getSubType().get()), (Matcher)Matchers.equalTo((Object)OAuth2AuthenticationType.GrantType.clientCredentials.toString()));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getTokenUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getScopes().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getScopes().get(0)), (Matcher)Matchers.equalTo((Object)"test"));
    }

    private static void assertOAuth2ImplicitConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.\"oauth2Implicit\""));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("accessToken", StringType.class, true)}));
        final Holder OAuthHttpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(new AuthenticationTypeVisitor(){

            public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
                throw new IllegalStateException("Should not be a generic HttpAuthenticationType");
            }

            public void visitOAuth2HttpAuthenticationType(OAuth2AuthenticationType oAuthHttpAuthenticationType) {
                OAuthHttpAuthenticationTypeHolder.setValue(oAuthHttpAuthenticationType);
            }
        });
        OAuth2ImplicitAuthenticationType oAuthHttpAuthenticationType = (OAuth2ImplicitAuthenticationType)OAuthHttpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getSubType().get()), (Matcher)Matchers.equalTo((Object)OAuth2AuthenticationType.GrantType.implicit.toString()));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getAuthorizationUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/authorize"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getScopes().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getScopes().get(0)), (Matcher)Matchers.equalTo((Object)"test"));
    }

    private static void assertOAuth2PasswordConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.\"oauth2Password\""));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("accessToken", StringType.class, true)}));
        final Holder OAuthHttpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(new AuthenticationTypeVisitor(){

            public void visitHttpAuthenticationType(HttpAuthenticationType httpAuthenticationType) {
                throw new IllegalStateException("Should not be a generic HttpAuthenticationType");
            }

            public void visitOAuth2HttpAuthenticationType(OAuth2AuthenticationType oAuthHttpAuthenticationType) {
                OAuthHttpAuthenticationTypeHolder.setValue(oAuthHttpAuthenticationType);
            }
        });
        OAuth2PasswordAuthenticationType oAuthHttpAuthenticationType = (OAuth2PasswordAuthenticationType)OAuthHttpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getSubType().get()), (Matcher)Matchers.equalTo((Object)OAuth2AuthenticationType.GrantType.password.toString()));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getRefreshUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getTokenUrl(), (Matcher)Matchers.equalTo((Object)"http://localhost/token"));
        MatcherAssert.assertThat((Object)oAuthHttpAuthenticationType.getScopes().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)oAuthHttpAuthenticationType.getScopes().get(0)), (Matcher)Matchers.equalTo((Object)"test"));
    }

    private static void assertBasicAuthConnection(ConnectionProviderModel connectionProviderModel) {
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"test001::Connector::connector.connections.basicAuth"));
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("user", StringType.class, true), ObjectFieldMatcher.fieldLike("pass", StringType.class, true)}));
        MatcherAssert.assertThat((Object)((String)MetadataUtils.getDefaultValue((DWType)properties.get(0).getValue()).get()), (Matcher)Matchers.is((Object)"http://localhost"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(httpAuthenticationTypeHolder::setValue);
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.basic));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    public static void assertAccountsValueProvider(ValueProviderModel valueProvider, String expectedModelReference) {
        MatcherAssert.assertThat((Object)valueProvider.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProvider.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)valueProvider.getName(), (Matcher)Matchers.equalTo((Object)"accountsValueProvider"));
        DWType inputType = valueProvider.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> properties = List.of(((ObjectType)inputType).getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("offset", NumberType.class, true), ObjectFieldMatcher.fieldLike("limit", NumberType.class, true)}));
        MatcherAssert.assertThat((Object)valueProvider.getProvidedValueType().getDataType(), (Matcher)IsInstanceOf.instanceOf(StringType.class));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)valueProvider.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> errorOutputProperties = List.of(errorOutputType.getProperties());
        MatcherAssert.assertThat(errorOutputProperties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("success", BooleanType.class, true), ObjectFieldMatcher.fieldLike("error", ObjectType.class, true)}));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        TestUtils.assertHttpResponseType((ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)errorOutputType, (String)"value").orElseThrow()).getValue(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)valueProvider.getDisplayPropertiesType().getDataType(), (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)valueProvider.isPaginated(), (Matcher)Matchers.is((Object)false));
    }

    public static void assertUsersValueProvider(ValueProviderModel valueProvider, String expectedModelReference) {
        MatcherAssert.assertThat((Object)valueProvider.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProvider.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)valueProvider.getName(), (Matcher)Matchers.equalTo((Object)"usersValueProvider"));
        MatcherAssert.assertThat((Object)valueProvider.getProvidedValueType().getDataType(), (Matcher)IsInstanceOf.instanceOf(StringType.class));
        DWType displayPropertiesType = valueProvider.getDisplayPropertiesType().getDataType();
        MatcherAssert.assertThat((Object)displayPropertiesType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)TypeUtils.resolveReferenceType((DWType)displayPropertiesType)).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("email", StringType.class, true)));
    }

    public static void assertMetadataProvider(MetadataProviderModel metadataProviderModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)metadataProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)metadataProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)metadataProviderModel.getName(), (Matcher)Matchers.equalTo((Object)"metadataProvider"));
        DWType inputType = metadataProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(SimpleReferenceType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)TypeUtils.resolveReferenceType((DWType)inputType)).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("objectType", StringType.class, true)));
        KeyValuePairType errorValue = (KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)metadataProviderModel.getErrorOutputType().getDataType())), (String)"error").orElseThrow();
        ObjectType error = (ObjectType)TypeUtils.getProperty((ObjectType)((ObjectType)errorValue.getValue()), (String)"value");
        MatcherAssert.assertThat(List.of(error.getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("errorMessage", StringType.class, true)));
    }

    private void assertAccountsPaginatedValueProvider(ValueProviderModel valueProvider, String expectedModelReference) {
        MatcherAssert.assertThat((Object)valueProvider.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProvider.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)valueProvider.getName(), (Matcher)Matchers.equalTo((Object)"accountsPaginatedValueProvider"));
        DWType inputType = valueProvider.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("offset", NumberType.class, true), ObjectFieldMatcher.fieldLike("limit", NumberType.class, true)}));
        MatcherAssert.assertThat((Object)valueProvider.getProvidedValueType().getDataType(), (Matcher)IsInstanceOf.instanceOf(StringType.class));
        KeyValuePairType errorValue = (KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)valueProvider.getErrorOutputType().getDataType())), (String)"error").orElseThrow();
        ObjectType error = (ObjectType)TypeUtils.getProperty((ObjectType)((ObjectType)errorValue.getValue()), (String)"value");
        TestUtils.assertHttpResponseType(error, bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)valueProvider.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    public static void assertGetUsersTrigger(TriggerModel triggerModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)triggerModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)triggerModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)triggerModel.getName(), (Matcher)Matchers.equalTo((Object)"getUsersTrigger"));
        MatcherAssert.assertThat((Object)triggerModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get Users Trigger"));
        DWType inputType = TypeUtils.resolveReferenceType((DWType)triggerModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("since", NumberType.class, true)));
        DWType outputType = TypeUtils.resolveReferenceType((DWType)triggerModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)outputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class, true), ObjectFieldMatcher.fieldLike("name", StringType.class, true), ObjectFieldMatcher.fieldLike("email", StringType.class, true), ObjectFieldMatcher.fieldLike("created_at", NumberType.class, true)}));
        DWType errorOutputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)triggerModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = TypeUtils.getProperty((ObjectType)((ObjectType)errorOutputType), (String)"error");
        MatcherAssert.assertThat(List.of(((ObjectType)errorOutputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        ObjectType errorOutputTypeValue = (ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)errorOutputType), (String)"value").orElseThrow()).getValue();
        TestUtils.assertHttpResponseType(errorOutputTypeValue, bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
    }

    public static void assertGetUsersPaginatedTrigger(TriggerModel triggerModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)triggerModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)triggerModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)triggerModel.getName(), (Matcher)Matchers.equalTo((Object)"getUsersTriggerPaginated"));
        MatcherAssert.assertThat((Object)triggerModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get Users Trigger"));
        DWType inputType = TypeUtils.resolveReferenceType((DWType)triggerModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)((ObjectType)inputType).getProperties().length, (Matcher)Matchers.is((Object)1));
        DWType outputType = TypeUtils.resolveReferenceType((DWType)triggerModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)outputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class, true), ObjectFieldMatcher.fieldLike("name", StringType.class, true), ObjectFieldMatcher.fieldLike("email", StringType.class, true), ObjectFieldMatcher.fieldLike("created_at", NumberType.class, true)}));
        DWType errorOutputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)triggerModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = TypeUtils.getProperty((ObjectType)((ObjectType)errorOutputType), (String)"error");
        MatcherAssert.assertThat(List.of(((ObjectType)errorOutputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        ObjectType errorOutputTypeValue = (ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)errorOutputType), (String)"value").orElseThrow()).getValue();
        TestUtils.assertHttpResponseType(errorOutputTypeValue, bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
    }

    public static void assertUpdateAccountByIdOperation(OperationModel operationModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)operationModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)operationModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"updateAccountById"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Update Account by Id"));
        ObjectType inputType = (ObjectType)operationModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("accountId", StringType.class, true), ObjectFieldMatcher.fieldLike("account", SimpleReferenceType.class, true)}));
        DWType outputType = TypeUtils.resolveReferenceType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        TestUtils.assertHttpResponseType((ObjectType)outputType, bodyField -> MatcherAssert.assertThat(List.of(((ObjectType)bodyField.getValue()).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class, true), ObjectFieldMatcher.fieldLike("name", StringType.class, true), ObjectFieldMatcher.fieldLike("email", StringType.class, true)})));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", UnionType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", UnionType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType((ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)errorOutputType, (String)"value").orElseThrow()).getValue(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
    }

    public static void assertGetAccountsOperation(OperationModel operationModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)operationModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)operationModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"getAccounts"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get Accounts"));
        ObjectType inputType = (ObjectType)operationModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("offset", NumberType.class, true), ObjectFieldMatcher.fieldLike("limit", NumberType.class, true)}));
        DWType outputType = operationModel.getOutputType().getDataType();
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType((ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)errorOutputType, (String)"value").orElseThrow()).getValue(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        DWType itemType = WeaveTypeSimplifier.simplifyWeaveType((DWType)TypeUtils.resolveReferenceType((DWType)((ArrayType)outputType).arrayOf()));
        MatcherAssert.assertThat((Object)itemType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(List.of(((ObjectType)itemType).getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class, true), ObjectFieldMatcher.fieldLike("name", StringType.class, true), ObjectFieldMatcher.fieldLike("email", StringType.class, true), ObjectFieldMatcher.fieldLike("createdAt", StringType.class, false), ObjectFieldMatcher.fieldLike("price", NumberType.class, false), ObjectFieldMatcher.fieldLike("priority", UnionType.class, false), ObjectFieldMatcher.fieldLike("role", UnionType.class, false)}));
    }

    public static void assertGetMessagesOperation(OperationModel operationModel, String expectedModelReference) {
        MatcherAssert.assertThat((Object)operationModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)operationModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"getMessages"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get Messages"));
        DWType inputType = operationModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(NullType.class));
        DWType outputType = TypeUtils.resolveReferenceType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        TestUtils.assertHttpResponseType((ObjectType)outputType, bodyField -> MatcherAssert.assertThat(List.of(((ObjectType)bodyField.getValue()).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("messages", ArrayType.class, true))));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType((ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)errorOutputType, (String)"value").orElseThrow()).getValue(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
    }

    private void assertTestFailuresOperation(OperationModel operationModel, String expectedModelReference) {
        String modelReference = (String)Assertions.assertDoesNotThrow(() -> (String)operationModel.getModelReference().orElseThrow());
        MatcherAssert.assertThat((Object)modelReference, (Matcher)Matchers.equalTo((Object)expectedModelReference));
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"testFailures"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Tests failures"));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
        List errorDefinitions = operationModel.getErrorDefinitions();
        MatcherAssert.assertThat((Object)errorDefinitions, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(0)).getKind(), (Matcher)Matchers.equalTo((Object)"__UNCHECKED"));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(1)).getKind(), (Matcher)Matchers.equalTo((Object)"__UNCHECKED"));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(2)).getKind(), (Matcher)Matchers.equalTo((Object)"__UNCHECKED"));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(3)).getKind(), (Matcher)Matchers.equalTo((Object)"__UNCHECKED"));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(0)).getCategories(), (Matcher)Matchers.equalTo(List.of("__UNEXPECTED")));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(1)).getCategories(), (Matcher)Matchers.equalTo(List.of("__HTTP_DEFAULT")));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(2)).getCategories(), (Matcher)Matchers.equalTo(List.of("__HTTP_4XX")));
        MatcherAssert.assertThat((Object)((ErrorModel)errorDefinitions.get(3)).getCategories(), (Matcher)Matchers.equalTo(List.of("__HTTP_5XX")));
    }
}

