/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.value.Holder;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.AnyType;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.WeaveType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class LinkWeaveModelLoader003Test
extends AbstractConnectivityModelTest {
    @Test
    void loadsConnectorModel() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("test003::Connector");
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"DataWeaveExtension"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Data Weave Extension"));
        Assertions.assertNull((Object)connectorModel.getDescription());
        MatcherAssert.assertThat(connectorModel.getConnectionProviders(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ConnectionProviderModel connectionProviderModel = connectorModel.getConnectionProviders().get(0);
        DWType inputType = connectionProviderModel.getInputType().getDataType();
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("baseUri", StringType.class, true), ObjectFieldMatcher.fieldLike("user", StringType.class, true), ObjectFieldMatcher.fieldLike("pass", StringType.class, true)}));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(httpAuthenticationTypeHolder::setValue);
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.basic));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(connectorModel.getValueProviders(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        LinkWeaveModelLoader003Test.assertUsersValueProvider(connectorModel.getValueProviders().get(0));
        MatcherAssert.assertThat(connectorModel.getOperations(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        LinkWeaveModelLoader003Test.assertGetUserByIdEndpoint(connectorModel.getOperations().get(0));
        LinkWeaveModelLoader003Test.assertGetUsersOperation(connectorModel.getOperations().get(1));
        LinkWeaveModelLoader003Test.assertGetUserByIdCustomOperation(connectorModel.getOperations().get(2));
    }

    private static void assertDefaultHttpParams(ObjectType connectorInputElement) {
        MatcherAssert.assertThat(List.of(connectorInputElement.getProperties()), (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)ObjectFieldMatcher.fieldLike("uri", ObjectType.class, true), (Matcher)ObjectFieldMatcher.fieldLike("query", ObjectType.class, true), (Matcher)ObjectFieldMatcher.fieldLike("headers", ObjectType.class, true), (Matcher)ObjectFieldMatcher.fieldLike("cookie", ObjectType.class, true), (Matcher)ObjectFieldMatcher.fieldLike("body", ObjectType.class, true))));
        MatcherAssert.assertThat(List.of(connectorInputElement.getProperties()), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("query", ObjectType.class, true), ObjectFieldMatcher.fieldLike("headers", ObjectType.class, true), ObjectFieldMatcher.fieldLike("cookie", ObjectType.class, true)}));
    }

    private static void assertUsersValueProvider(ValueProviderModel valueProvider) {
        MatcherAssert.assertThat((Object)valueProvider.getName(), (Matcher)Matchers.equalTo((Object)"usersValueProvider"));
        ObjectType inputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)valueProvider.getInputType().getDataType());
        LinkWeaveModelLoader003Test.assertDefaultHttpParams(inputType);
        MatcherAssert.assertThat(TestUtils.getPropertiesOfField(inputType, "query").orElseThrow(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("offset", NumberType.class, false), ObjectFieldMatcher.fieldLike("limit", NumberType.class, true)}));
        MatcherAssert.assertThat((Object)valueProvider.getProvidedValueType().getDataType(), (Matcher)IsInstanceOf.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)valueProvider.getDisplayPropertiesType().getDataType(), (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)valueProvider.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType((ObjectType)((org.mule.weave.v2.api.tooling.ts.KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)errorOutputType, (String)"value").orElseThrow()).getValue(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)valueProvider.isPaginated(), (Matcher)Matchers.is((Object)false));
    }

    public static void assertGetUserByIdEndpoint(OperationModel operationModel) {
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"getUserByIdEndpoint"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get user by id"));
        DWType inputWeaveType = TypeUtils.resolveReferenceType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputWeaveType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType inputType = (ObjectType)inputWeaveType;
        LinkWeaveModelLoader003Test.assertDefaultHttpParams(inputType);
        MatcherAssert.assertThat(TestUtils.getPropertiesOfField(inputType, "uri").orElseThrow(), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("userId", NumberType.class, true)));
        MatcherAssert.assertThat(TestUtils.getPropertiesOfField(inputType, "query").orElseThrow(), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("metadata", StringType.class, true)));
        MatcherAssert.assertThat(TestUtils.getPropertiesOfField(inputType, "headers").orElseThrow(), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("customHeader", StringType.class, true)));
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        TestUtils.assertHttpResponseType((ObjectType)outputType, bodyField -> {
            List<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> properties = List.of(((ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyField.getValue())).getProperties());
            MatcherAssert.assertThat(properties, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("userName", StringType.class, true), ObjectFieldMatcher.fieldLike("surname", StringType.class, true), ObjectFieldMatcher.fieldLike("age", NumberType.class, true), ObjectFieldMatcher.fieldLike("metadata", ObjectType.class, true)}));
            org.mule.weave.v2.api.tooling.ts.KeyValuePairType[] metadataFields = ((ObjectType)properties.stream().filter(x -> x.getKeyName().equals("metadata")).findFirst().orElseThrow().getValue()).getProperties();
            List<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> metadataFieldsSimplified = Stream.of(metadataFields).map(kvt -> new KeyValuePairType((WeaveType)kvt.getKey(), (WeaveType)WeaveTypeSimplifier.simplifyWeaveType((DWType)kvt.getValue()), kvt.isOptionalKey(), kvt.repeated())).toList();
            MatcherAssert.assertThat(metadataFieldsSimplified, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("uri", NumberType.class, true), ObjectFieldMatcher.fieldLike("query", StringType.class, true), ObjectFieldMatcher.fieldLike("headers", StringType.class, true)}));
        });
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType(TestUtils.getFieldObjectValueByName(errorOutputType, "value").orElseThrow(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
    }

    public static void assertGetUsersOperation(OperationModel operationModel) {
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"getUsers"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get Users"));
        DWType inputMetadataType = TypeUtils.resolveReferenceType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputMetadataType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType inputType = (ObjectType)inputMetadataType;
        LinkWeaveModelLoader003Test.assertDefaultHttpParams(inputType);
        MatcherAssert.assertThat(TestUtils.getPropertiesOfField(inputType, "query").orElseThrow(), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike("limit", NumberType.class, true)));
        DWType outputType = operationModel.getOutputType().getDataType();
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType(TestUtils.getFieldObjectValueByName(errorOutputType, "value").orElseThrow(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        DWType itemType = TypeUtils.resolveReferenceType((DWType)((ArrayType)outputType).arrayOf());
        MatcherAssert.assertThat((Object)itemType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(List.of(((ObjectType)itemType).getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class, true), ObjectFieldMatcher.fieldLike("name", StringType.class, true), ObjectFieldMatcher.fieldLike("email", StringType.class, true)}));
    }

    public static void assertGetUserByIdCustomOperation(OperationModel operationModel) {
        MatcherAssert.assertThat((Object)operationModel.getName(), (Matcher)Matchers.equalTo((Object)"getUserByIdCustom"));
        MatcherAssert.assertThat((Object)operationModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Get user by id custom"));
        DWType inputMetadataType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(((ObjectType)inputMetadataType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("userId", NumberType.class, true), ObjectFieldMatcher.fieldLike("metadata", StringType.class, true), ObjectFieldMatcher.fieldLike("customHeader", StringType.class, true)}));
        DWType outputType = TypeUtils.resolveReferenceType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        TestUtils.assertHttpResponseType((ObjectType)outputType, bodyField -> {
            List<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> bodyFields = List.of(((ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyField.getValue())).getProperties());
            MatcherAssert.assertThat(bodyFields, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("userName", StringType.class, true), ObjectFieldMatcher.fieldLike("surname", StringType.class, true), ObjectFieldMatcher.fieldLike("age", NumberType.class, true), ObjectFieldMatcher.fieldLike("metadata", ObjectType.class, true)}));
            org.mule.weave.v2.api.tooling.ts.KeyValuePairType[] metadataFields = ((ObjectType)bodyFields.stream().filter(x -> x.getKeyName().equals("metadata")).findFirst().orElseThrow().getValue()).getProperties();
            MatcherAssert.assertThat(List.of(metadataFields), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("uri", NumberType.class, true), ObjectFieldMatcher.fieldLike("query", StringType.class, true), ObjectFieldMatcher.fieldLike("headers", StringType.class, true)}));
        });
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("categories", ArrayType.class, true), ObjectFieldMatcher.fieldLike("description", UnionType.class, true), ObjectFieldMatcher.fieldLike("kind", StringType.class, true), ObjectFieldMatcher.fieldLike("value", ObjectType.class, true)}));
        TestUtils.assertHttpResponseType(TestUtils.getFieldObjectValueByName(errorOutputType, "value").orElseThrow(), bodyField -> MatcherAssert.assertThat((Object)bodyField.getValue(), (Matcher)IsInstanceOf.instanceOf(AnyType.class)));
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.equalTo((Object)false));
    }
}

