/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataInjectionModelLoaderTest
extends AbstractConnectivityModelTest {
    @Test
    void loadConnectionSemanticTerms() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataInjection::Connector");
        ConnectionProviderModel connection = connectorModel.getConnectionProviders().get(0);
        DWType inputType = connection.getInputType().getDataType();
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "pass"), (Matcher)Matchers.contains((Object[])new String[]{"password"}));
        connection = connectorModel.getConnectionProviders().get(1);
        inputType = TypeUtils.resolveReferenceType((DWType)connection.getInputType().getDataType());
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "username"), (Matcher)Matchers.contains((Object[])new String[]{"username"}));
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "password"), (Matcher)Matchers.contains((Object[])new String[]{"password"}));
        connection = connectorModel.getConnectionProviders().get(2);
        inputType = TypeUtils.resolveReferenceType((DWType)connection.getInputType().getDataType());
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "token"), (Matcher)Matchers.contains((Object[])new String[]{"password", "secretToken"}));
        connection = connectorModel.getConnectionProviders().get(3);
        inputType = TypeUtils.resolveReferenceType((DWType)connection.getInputType().getDataType());
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "apiKey"), (Matcher)Matchers.contains((Object[])new String[]{"apiKey"}));
        connection = connectorModel.getConnectionProviders().get(4);
        inputType = TypeUtils.resolveReferenceType((DWType)connection.getInputType().getDataType());
        MatcherAssert.assertThat(TestUtils.requireSemanticTermsOnFieldValue(inputType, "accessToken"), (Matcher)Matchers.contains((Object[])new String[]{"password", "secretToken"}));
    }

    @Test
    void loadsFieldMetadata() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataInjection::Connector");
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"DataWeaveExtension"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Data Weave Extension"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        ConnectionProviderModel connection = connectorModel.getConnectionProviders().get(0);
        ObjectType connectionInputType = (ObjectType)connection.getInputType().getDataType();
        MatcherAssert.assertThat((Object)MetadataUtils.requireLabel((DWType)connectionInputType), (Matcher)Matchers.equalTo((Object)"Twilio basic connection"));
        TestUtils.assertLabel(connectionInputType, "baseUri", "The base uri that will be used for all HTTP requests");
        TestUtils.assertLabel(connectionInputType, "user", "The username used to authenticate the requests");
        TestUtils.assertLabel(connectionInputType, "pass", "The password used to authenticate the requests");
        MatcherAssert.assertThat(connectorModel.getOperations(), (Matcher)Matchers.hasSize((int)1));
        OperationModel operation = connectorModel.getOperations().get(0);
        MatcherAssert.assertThat((Object)operation.getName(), (Matcher)Matchers.equalTo((Object)"createTicket"));
        ObjectType inputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        Assertions.assertTrue((boolean)DWTypeUtils.getFieldByName((ObjectType)inputType, (String)"projectId").isPresent());
        DWType projectIdFieldValue = DWTypeUtils.requireFieldByName((ObjectType)inputType, (String)"projectId").getValue();
        Assertions.assertEquals((int)2, (int)projectIdFieldValue.getTypeMetadata().length);
        MatcherAssert.assertThat((Object)MetadataUtils.getValueProvider((DWType)projectIdFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        ProviderReference providerReference = MetadataUtils.requireValueProvider((DWType)projectIdFieldValue);
        MatcherAssert.assertThat((Object)providerReference.getName(), (Matcher)Matchers.equalTo((Object)"projectsValueProvider"));
        MatcherAssert.assertThat((Object)providerReference.getArguments(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)MetadataUtils.getDescription((DWType)projectIdFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        String description = MetadataUtils.requireDescription((DWType)projectIdFieldValue);
        MatcherAssert.assertThat((Object)description, (Matcher)Matchers.equalTo((Object)"The project where the ticket is created"));
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)inputType, (String)"ticketType").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType ticketTypeFieldValue = DWTypeUtils.requireFieldByName((ObjectType)inputType, (String)"ticketType").getValue();
        Assertions.assertEquals((int)2, (int)ticketTypeFieldValue.getTypeMetadata().length);
        MatcherAssert.assertThat((Object)MetadataUtils.getValueProvider((DWType)ticketTypeFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        providerReference = MetadataUtils.requireValueProvider((DWType)ticketTypeFieldValue);
        MatcherAssert.assertThat((Object)providerReference.getName(), (Matcher)Matchers.equalTo((Object)"ticketTypesValueProvider"));
        MatcherAssert.assertThat((Object)providerReference.getArguments(), (Matcher)Matchers.hasSize((int)1));
        ProviderArgument projectFieldMapping = (ProviderArgument)providerReference.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)projectFieldMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"projectId"}));
        MatcherAssert.assertThat((Object)projectFieldMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"id"}));
        MatcherAssert.assertThat((Object)MetadataUtils.getDescription((DWType)ticketTypeFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        description = MetadataUtils.requireDescription((DWType)ticketTypeFieldValue);
        MatcherAssert.assertThat((Object)description, (Matcher)Matchers.equalTo((Object)"The type of the ticket to create"));
        TestUtils.assertFormat(inputType, "ticketDate", "date");
        TestUtils.assertFormat(inputType, "createdAt", "date-time");
        TestUtils.assertFormat(inputType, "amount", "integer");
        TestUtils.assertFormat(inputType, "size", "float");
        TestUtils.assertFormat(inputType, "price", "double");
        TestUtils.assertFormat(inputType, "count", "int32");
        TestUtils.assertFormat(inputType, "total", "int64");
        ObjectType outputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)DWTypeUtils.requireFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getOutputType().getDataType())), (String)"body").getValue());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        TestUtils.assertFormat(outputType, "ticketDate", "date");
        TestUtils.assertFormat(outputType, "createdAt", "date-time");
        TestUtils.assertFormat(outputType, "amount", "integer");
        TestUtils.assertFormat(outputType, "size", "float");
        TestUtils.assertFormat(outputType, "price", "double");
        TestUtils.assertFormat(outputType, "count", "int32");
        TestUtils.assertFormat(outputType, "total", "int64");
        MatcherAssert.assertThat(connectorModel.getTriggers(), (Matcher)Matchers.hasSize((int)1));
        TriggerModel trigger = connectorModel.getTriggers().get(0);
        MatcherAssert.assertThat((Object)trigger.getName(), (Matcher)Matchers.equalTo((Object)"getUsersTrigger"));
        ObjectType triggerInputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)trigger.getInputType().getDataType());
        MatcherAssert.assertThat((Object)triggerInputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        Assertions.assertEquals((int)2, (int)triggerInputType.getProperties().length);
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)triggerInputType, (String)"since").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)triggerInputType, (String)"project").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType triggerProjectFieldValue = DWTypeUtils.requireFieldByName((ObjectType)triggerInputType, (String)"project").getValue();
        Assertions.assertEquals((int)2, (int)triggerProjectFieldValue.getTypeMetadata().length);
        MatcherAssert.assertThat((Object)MetadataUtils.getValueProvider((DWType)triggerProjectFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        ProviderReference providerTriggerReference = MetadataUtils.requireValueProvider((DWType)triggerProjectFieldValue);
        MatcherAssert.assertThat((Object)providerTriggerReference.getName(), (Matcher)Matchers.equalTo((Object)"projectsValueProvider"));
        MatcherAssert.assertThat((Object)providerTriggerReference.getArguments(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)MetadataUtils.getDescription((DWType)triggerProjectFieldValue).isPresent(), (Matcher)Matchers.is((Object)true));
        String descriptionTriggerField = MetadataUtils.requireDescription((DWType)triggerProjectFieldValue);
        MatcherAssert.assertThat((Object)descriptionTriggerField, (Matcher)Matchers.equalTo((Object)"The project where the ticket is created"));
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)triggerInputType, (String)"since").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType sinceDateField = DWTypeUtils.requireFieldByName((ObjectType)triggerInputType, (String)"since").getValue();
        MatcherAssert.assertThat((Object)MetadataUtils.getFormat((DWType)sinceDateField).isPresent(), (Matcher)Matchers.is((Object)true));
        ObjectType triggerOutputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)trigger.getOutputType().getDataType());
        Assertions.assertEquals((int)4, (int)triggerOutputType.getProperties().length);
        MatcherAssert.assertThat(List.of(triggerOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("id", StringType.class), ObjectFieldMatcher.fieldLike("name", StringType.class), ObjectFieldMatcher.fieldLike("email", StringType.class), ObjectFieldMatcher.fieldLike("created_at", SimpleReferenceType.class)}));
        TestUtils.assertFormat(triggerOutputType, "created_at", "date");
    }
}

