/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.loader.ConnectorDiscoveryAnnotationProcessor;
import com.mulesoft.connectivity.linkweave.api.loader.LoaderUtils;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.impl.SourceOnlyWeaveResourceResolver;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Option;

public class LanguageModelLoader<M extends Model, B extends Model.Builder<M, B>> {
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final ModelLoader<M, B, DataWeaveObjectReference> modelLoader;
    private final NameIdentifier annotationNameIdentifier;

    public LanguageModelLoader(DataWeaveScriptingEngine dataWeaveEngine, ModelLoader<M, B, DataWeaveObjectReference> modelLoader, NameIdentifier annotationNameIdentifier1) {
        this.dataWeaveEngine = dataWeaveEngine;
        this.modelLoader = modelLoader;
        this.annotationNameIdentifier = annotationNameIdentifier1;
    }

    public M loadModule(String moduleReference, @Nullable Object extraData) {
        String connectorReference = this.getConnectorReference(moduleReference);
        return this.loadConnector(connectorReference, extraData);
    }

    public M loadModule(String moduleReference) {
        return this.loadModule(moduleReference, null);
    }

    public M loadConnector(String connectorReference) {
        return this.loadConnector(connectorReference, null);
    }

    public M loadConnector(String connectorReference, @Nullable Object extraData) {
        DWType connectorWeaveType = this.inferType(connectorReference);
        try {
            return this.modelLoader.loadModel(new DataWeaveObjectReference(connectorReference, connectorWeaveType, (Map)LoaderUtils.readValue(this.dataWeaveEngine, connectorReference)), null, extraData);
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error while describing model for: " + connectorReference, e);
        }
    }

    private DWType inferType(String connectorReference) {
        Option weaveTypeOption;
        try {
            this.dataWeaveEngine.compile(connectorReference).write(new ScriptingBindings()).getContent();
            weaveTypeOption = this.dataWeaveEngine.inferTypeOf(connectorReference).map(v -> v);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Caught exception while finding reference for connector: " + connectorReference, ex);
        }
        if (!weaveTypeOption.isDefined()) {
            throw new IllegalStateException("Unable to find reference for connector: " + connectorReference);
        }
        return (DWType)weaveTypeOption.get();
    }

    private String getConnectorReference(String moduleReference) {
        Objects.requireNonNull(moduleReference, "moduleReference cannot be null");
        String connectorVariableName = this.discoverConnectorVariableName(moduleReference);
        return moduleReference + "::" + connectorVariableName;
    }

    private List<String> discoverConnectorVariableNames(String connectorReference) {
        ConnectorDiscoveryAnnotationProcessor connectorDiscoveryAnnotationProcessor = new ConnectorDiscoveryAnnotationProcessor(this.annotationNameIdentifier);
        ParserConfiguration parserConfiguration = new ParserConfigurationBuilder().addAnnotationProcessor(this.annotationNameIdentifier, (DWAnnotationProcessor)connectorDiscoveryAnnotationProcessor).build();
        DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine(ModuleComponentsFactory.apply((WeaveResourceResolver)new SourceOnlyWeaveResourceResolver((WeaveResourceResolver)ClassLoaderWeaveResourceResolver.apply())), parserConfiguration);
        dataWeaveScriptingEngine.compile("import * from " + connectorReference + "\n---\ntrue");
        List<String> connectorVariableNames = connectorDiscoveryAnnotationProcessor.getConnectorVariableNames();
        if (connectorVariableNames.isEmpty()) {
            throw new IllegalStateException("There is no variable annotated as @" + String.valueOf(this.annotationNameIdentifier));
        }
        return connectorVariableNames;
    }

    private String discoverConnectorVariableName(String connectorReference) {
        List<String> connectorVariableNames = this.discoverConnectorVariableNames(connectorReference);
        if (connectorVariableNames.size() > 1) {
            throw new IllegalStateException("More than one variable annotated as @" + String.valueOf(this.annotationNameIdentifier) + " was found: " + String.valueOf(connectorVariableNames));
        }
        return connectorVariableNames.get(0);
    }
}

