/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection;

import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class HttpAuthenticationType
extends AuthenticationType {
    private final Type type;
    private final @Nullable String subType;

    public HttpAuthenticationType(Type type, @Nullable String subType) {
        this.type = Objects.requireNonNull(type, "'type' cannot be null");
        this.subType = subType;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getSubType() {
        return Optional.ofNullable(this.subType);
    }

    @Override
    public void accept(AuthenticationTypeVisitor authenticationTypeVisitor) {
        authenticationTypeVisitor.visitHttpAuthenticationType(this);
    }

    public String toString() {
        return "HttpAuthenticationType{type=" + String.valueOf((Object)this.type) + ", subType='" + this.subType + "'}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpAuthenticationType that = (HttpAuthenticationType)o;
        return this.type == that.type && Objects.equals(this.subType, that.subType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.subType});
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        basic,
        bearer,
        apiKey{

            @Override
            public AuthenticationType createHttpAuthenticationType(Map<?, ?> connectionValue) {
                Map attributesValues = (Map)connectionValue.get("attributes");
                return new ApiKeyHttpAuthenticationType((String)connectionValue.get("subType"), ApiKeyHttpAuthenticationType.In.fromString((String)attributesValues.get("in")), (String)attributesValues.get("name"));
            }
        }
        ,
        oauth2{

            @Override
            public AuthenticationType createHttpAuthenticationType(Map<?, ?> connectionValue) {
                return OAuth2AuthenticationType.create((Map)connectionValue.get("attributes"));
            }
        }
        ,
        custom;


        public AuthenticationType createHttpAuthenticationType(Map<?, ?> connectionValue) {
            return new HttpAuthenticationType(this, (String)connectionValue.get("subType"));
        }

        public static Type fromString(String type) {
            return switch (type) {
                case "basic" -> basic;
                case "bearer" -> bearer;
                case "apiKey" -> apiKey;
                case "oauth2" -> oauth2;
                case "custom" -> custom;
                default -> throw new IllegalArgumentException("Unsupported type: " + type);
            };
        }
    }
}

