%dw 2.7

import * from dw::core::Arrays

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@OperationElement
var unauthorizedOp: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "unauthorized",
    displayName: "Unauthorized",
    executor: (parameter, connection) -> failure(
        	{
                contentType: "application/json",
                status: 401,
                headers: {},
                cookies: {}
    		}, {
    		    kind: "401",
    		    categories: []
    		}, "401 - Unauthorized")
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
		isAlive,
		(response) -> { isValid: response.value.status == 200 }
	)
}

@TestConnectionElement()
var httpTestConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> {
            isValid: response.value.status == 200,
            message:
                if (response.success is true)
                 "Connection test succeeded"
                else if (response.error.value.status?)
                 "Connection test failed - Http status code: " ++ response.error.value.status as String
                else
                 "Connection test failed",
            (error:
                if (isEmpty(response.error.value.body.^raw))
                 write(response.error.value.body, "application/dw") as String
                else
                 response.error.value.body.^raw as String
            ) if (response.success is false and response.error.value.body?)
        }
    )
}

@TestConnectionElement()
var failingTestConnection = {
	validate: (c): ConnectionValidationResult -> { isValid: false, error: "D", message: "M" }
}

@ConnectionElement()
var basicAuthConnectionProvider = defineBasicHttpConnectionProvider<{baseUri: String, user: String, pass: String}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

@ConnectionElement()
var basicAuthConnectionProviderWithTestConnection = defineBasicHttpConnectionProvider<{baseUri: String, user: String, pass: String}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
) ++ {
    validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var bearerAuthConnectionProvider = defineBearerHttpConnectionProvider<{baseUri: String, token: String}>(
    (parameter) -> {token: parameter.token},
    (parameter) -> {baseUri: parameter.baseUri}
)

@ConnectionElement()
var bearerAuthConnectionProviderWithTestConnection = defineBearerHttpConnectionProvider<{baseUri: String, token: String}>(
    (parameter) -> {token: parameter.token},
    (parameter) -> {baseUri: parameter.baseUri}
) ++ {
    validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}
