/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.persistence.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mulesoft.connectivity.linkweave.api.model.CanonicalConnectivityModel;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogCollector;
import java.lang.reflect.Type;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;

public class CanonicalConnectivityModelTypeAdapter
implements JsonSerializer<CanonicalConnectivityModel> {
    private final WeaveTypeCatalogCollector catalogCollector;

    public CanonicalConnectivityModelTypeAdapter(WeaveTypeCatalogCollector catalogCollector) {
        this.catalogCollector = catalogCollector;
    }

    public JsonElement serialize(CanonicalConnectivityModel src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add("connections", context.serialize(src.getConnectionProviders()));
        result.add("operations", context.serialize(src.getOperations()));
        result.add("triggers", context.serialize(src.getTriggers()));
        src.getTestConnection().ifPresent(testConnectionModel -> result.add("testConnection", context.serialize(testConnectionModel)));
        result.add("catalog", this.serializeCatalog());
        return result;
    }

    private JsonElement serializeCatalog() {
        return new JsonPrimitive(DefaultDWTypeCatalog.loader().withErrorHandler(errorMessages -> {
            throw new RuntimeException(String.join((CharSequence)"\n", errorMessages));
        }).withTypes(this.catalogCollector.getCatalog()).build().write());
    }
}

