/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.operation;

import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public abstract class OperationResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    private OperationResult() {
    }

    public abstract boolean isSuccess();

    public abstract T getValue();

    public abstract ResultError getErrorValue();

    public abstract <Z> OperationResult<Z> map(Function<? super T, ? extends Z> var1);

    public abstract <X extends Throwable> T orElseThrow(Function<ResultError, ? extends X> var1) throws X;

    public abstract OperationResult<T> or(Function<ResultError, OperationResult<? extends T>> var1);

    public static <T> OperationResult<T> success(T value) {
        return new SuccessfulOperationResult<T>(Objects.requireNonNull(value));
    }

    public static <T> OperationResult<T> failure(ResultError errorValue) {
        return new FailedOperationResult(Objects.requireNonNull(errorValue, "The error value must not be null"));
    }

    private static class SuccessfulOperationResult<T>
    extends OperationResult<T> {
        private static final long serialVersionUID = 1L;
        private final T value;

        private SuccessfulOperationResult(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public ResultError getErrorValue() {
            throw new IllegalStateException("Tried to access an error value from a successful result");
        }

        @Override
        public <Z> OperationResult<Z> map(Function<? super T, ? extends Z> mapper) {
            return SuccessfulOperationResult.success(Objects.requireNonNull(mapper).apply(this.value));
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<ResultError, ? extends X> exceptionSupplier) {
            Objects.requireNonNull(exceptionSupplier);
            return this.getValue();
        }

        @Override
        public OperationResult<T> or(Function<ResultError, OperationResult<? extends T>> nextCall) {
            Objects.requireNonNull(nextCall);
            return this;
        }

        public String toString() {
            return "SUCCESS: " + String.valueOf(this.getValue());
        }
    }

    private static class FailedOperationResult<T>
    extends OperationResult<T> {
        private static final long serialVersionUID = 1L;
        private final ResultError errorValue;

        private FailedOperationResult(ResultError errorValue) {
            this.errorValue = errorValue;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T getValue() {
            throw new IllegalStateException("Tried to access a value from a failed result");
        }

        @Override
        public ResultError getErrorValue() {
            return this.errorValue;
        }

        @Override
        public <Z> OperationResult<Z> map(Function<? super T, ? extends Z> mapper) {
            Objects.requireNonNull(mapper);
            return this;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<ResultError, ? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.apply(this.getErrorValue());
        }

        @Override
        public OperationResult<T> or(Function<ResultError, OperationResult<? extends T>> nextCall) {
            return nextCall.apply(this.getErrorValue());
        }

        public String toString() {
            return "ERROR: " + String.valueOf(this.getErrorValue());
        }
    }
}

