/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModelLoaderFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class PaginationTests {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<TestConnectorModel, TestConnectorModel.Builder> modelLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new TestConnectorModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    private final ModelInterpreter modelInterpreter = new ModelInterpreter(this.dataWeaveEngine, new ModelInterpreterConfig.Builder().build());

    @Test
    void notPaginatedLoader() {
        TestConnectorModel connector = (TestConnectorModel)this.modelLoader.loadModule("com::mulesoft::connectivity::paypal::Connector");
        OperationModel operation = connector.getOperation("GetInvoicesDetailsById");
        ObjectType outputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operation.getOutputType().getDataType());
        List<String> paramNames = Arrays.stream(outputType.getProperties()).map(KeyValuePairType::getKeyName).toList();
        MatcherAssert.assertThat((Object)operation.isPaginated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(paramNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"items", "total"}));
    }

    @Test
    void notPaginatedRuntime() {
        TestConnectorModel connector = (TestConnectorModel)this.modelLoader.loadModule("com::mulesoft::connectivity::paypal::Connector");
        ConnectionProviderModel connection = connector.getConnectionProviders().get(0);
        OperationModel operation = connector.getOperation("GetInvoicesDetailsById");
        OperationResult res = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connection, new Object(), (BaseExecutableComponentModel)operation, Map.of("id", 123));
        MatcherAssert.assertThat((Object)res.isSuccess(), (Matcher)Matchers.is((Object)true));
        Map invoice = (Map)res.getValue();
        MatcherAssert.assertThat((Object)invoice, (Matcher)Matchers.hasEntry((Object)"total", (Object)100));
        List items = (List)invoice.get("items");
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
    }
}

