/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import java.util.Objects;
import org.mule.weave.v2.api.tooling.ts.DWType;

public class DataWeaveReference<T> {
    protected final String path;
    protected final DWType type;
    protected final T value;

    public DataWeaveReference(String path, DWType type, T value) {
        this.path = Objects.requireNonNull(path, "path");
        this.type = Objects.requireNonNull(type, "type");
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public DWType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public String asString() {
        try {
            return (String)this.value;
        }
        catch (ClassCastException e) {
            throw new InvalidConnectorException("Expected '" + this.path + "' to be a string, but it's '" + String.valueOf(this.getType()) + "'", this.type.getLocation());
        }
    }

    public boolean asBoolean() {
        try {
            return (Boolean)this.value;
        }
        catch (ClassCastException e) {
            throw new InvalidConnectorException("Expected '" + this.path + "' to be a boolean, but it's '" + String.valueOf(this.getType()) + "'", this.type.getLocation());
        }
    }

    public DataWeaveObjectReference asObjectReference() {
        try {
            return (DataWeaveObjectReference)this;
        }
        catch (ClassCastException e) {
            throw new InvalidConnectorException("Expected '" + this.path + "' to be an object, but it's '" + String.valueOf(this.getType()) + "'", this.type.getLocation());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path='" + this.path + "', type=" + String.valueOf(this.type) + ", value=" + String.valueOf(this.value) + "}";
    }
}

