/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import java.util.Optional;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ObjectDataWeaveValue;
import org.mule.weave.v2.runtime.SimpleDataWeaveValue;

class DataWeaveLiveValue
extends DataWeaveCall {
    protected final ExecuteResult result;

    DataWeaveLiveValue(ExecuteResult result, ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveScriptingEngine) {
        super(config, dataWeaveScriptingEngine);
        this.result = result;
        this.bind("result", result);
        this.registerCloseable((AutoCloseable)result);
        this.freeze();
    }

    public DataWeaveCall call() {
        return this.newCall();
    }

    ExecuteResult getExecuteResult() {
        return this.result;
    }

    private Optional<DataWeaveValue> selectDataWeaveValue(String name) {
        DataWeaveValue dataWeaveValue = this.result.asDWValue();
        if (!(dataWeaveValue instanceof ObjectDataWeaveValue)) {
            throw new IllegalStateException("Not an object");
        }
        ObjectDataWeaveValue object = (ObjectDataWeaveValue)dataWeaveValue;
        DataWeaveValue value = (DataWeaveValue)object.select(name).getOrElse(() -> null);
        return Optional.ofNullable(value);
    }

    private Optional<Object> selectSimpleValue(String name) {
        return this.selectDataWeaveValue(name).map(v -> ((SimpleDataWeaveValue)v).value());
    }

    Optional<Boolean> selectBoolean(String name) {
        return this.selectSimpleValue(name).map(Boolean.class::cast);
    }
}

