/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class CanonicalConnectivityModel {
    private final @Nullable TestConnectionModel testConnection;
    private final List<ConnectionProviderModel> connectionProviders;
    private final List<OperationModel> operations;
    private final List<TriggerModel> triggers;

    public static CanonicalConnectivityModelBuilder builder() {
        return new CanonicalConnectivityModelBuilder();
    }

    private CanonicalConnectivityModel(@Nullable TestConnectionModel testConnection, List<ConnectionProviderModel> connectionProviders, List<OperationModel> operations, List<TriggerModel> triggers) {
        this.testConnection = testConnection;
        this.connectionProviders = connectionProviders;
        this.operations = operations;
        this.triggers = triggers;
    }

    public Optional<TestConnectionModel> getTestConnection() {
        return Optional.ofNullable(this.testConnection);
    }

    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.connectionProviders;
    }

    public List<OperationModel> getOperations() {
        return this.operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().stream().filter(operation -> operation.getName().equals(operationName)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find operation '" + operationName + "'"));
    }

    public List<TriggerModel> getTriggers() {
        return this.triggers;
    }

    public static class CanonicalConnectivityModelBuilder {
        private @Nullable TestConnectionModel testConnection;
        private List<ConnectionProviderModel> connectionProviders = new ArrayList<ConnectionProviderModel>();
        private List<OperationModel> operations = new ArrayList<OperationModel>();
        private List<TriggerModel> triggers = new ArrayList<TriggerModel>();

        public CanonicalConnectivityModelBuilder testConnection(@Nullable TestConnectionModel testConnection) {
            this.testConnection = testConnection;
            return this;
        }

        public CanonicalConnectivityModelBuilder connectionProviders(List<ConnectionProviderModel> connectionProviders) {
            this.connectionProviders = connectionProviders;
            return this;
        }

        public CanonicalConnectivityModelBuilder operations(List<OperationModel> operations) {
            this.operations = operations;
            return this;
        }

        public CanonicalConnectivityModelBuilder triggers(List<TriggerModel> triggers) {
            this.triggers = triggers;
            return this;
        }

        public CanonicalConnectivityModel build() {
            return new CanonicalConnectivityModel(this.testConnection, this.connectionProviders, this.operations, this.triggers);
        }
    }
}

