/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.test;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.ts.ObjectType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestUtils {
    public static final org.mule.weave.v2.api.tooling.ts.ObjectType EMPTY_OBJECT = new ObjectType(TestUtils.emptySeq(), false, false);

    private TestUtils() {
    }

    public static void assertHttpResponseType(org.mule.weave.v2.api.tooling.ts.ObjectType objectType, ObjectFieldTypeAssertion bodyAssertion) {
        List<KeyValuePairType> properties = List.of(objectType.getProperties());
        MatcherAssert.assertThat(properties, (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("contentType", StringType.class, false), ObjectFieldMatcher.fieldLike("status", NumberType.class, true), ObjectFieldMatcher.fieldLike("statusText", StringType.class, false), ObjectFieldMatcher.fieldLike("headers", org.mule.weave.v2.api.tooling.ts.ObjectType.class, true), ObjectFieldMatcher.fieldLike("body", DWType.class, false), ObjectFieldMatcher.fieldLike("cookies", org.mule.weave.v2.api.tooling.ts.ObjectType.class, true)}));
        KeyValuePairType body = new ArrayList<KeyValuePairType>(properties).get(4);
        MatcherAssert.assertThat((Object)body.getKeyName(), (Matcher)Matchers.equalTo((Object)"body"));
        bodyAssertion.assertField(body);
    }

    public static Optional<org.mule.weave.v2.api.tooling.ts.ObjectType> getFieldObjectValueByName(org.mule.weave.v2.api.tooling.ts.ObjectType weaveType, String name) {
        return DWTypeUtils.getFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)name).map(KeyValuePairType::getValue).map(org.mule.weave.v2.api.tooling.ts.ObjectType.class::cast);
    }

    public static Optional<List<KeyValuePairType>> getPropertiesOfField(org.mule.weave.v2.api.tooling.ts.ObjectType weaveType, String name) {
        return TestUtils.getFieldObjectValueByName(weaveType, name).map(org.mule.weave.v2.api.tooling.ts.ObjectType::getProperties).map(List::of);
    }

    public static ProviderReference requireMetadataProviderOnFieldValue(DWType weaveType, String fieldName) {
        return MetadataUtils.requireMetadataProvider((DWType)DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType), (String)fieldName).getValue());
    }

    public static Set<String> requireSemanticTermsOnFieldValue(DWType weaveType, String fieldName) {
        return MetadataUtils.requireSemanticTerms((DWType)DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType), (String)fieldName).getValue());
    }

    public static String requireMetadataLabelOnFieldValue(org.mule.weave.v2.api.tooling.ts.ObjectType weaveType, String fieldName) {
        return MetadataUtils.requireLabel((DWType)DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)fieldName).getValue());
    }

    public static void assertValueProvider(TestConnectorModel connectorModel, DWType weaveType, String expectedName, Matcher<Collection<?>> argumentMatcher) {
        TestUtils.assertValueProvider(weaveType, expectedName, argumentMatcher);
        Assertions.assertNotNull((Object)connectorModel.getValueProvider(MetadataUtils.requireValueProvider((DWType)weaveType).getName()));
    }

    public static void assertValueProvider(DWType weaveType, String expectedName, Matcher<Collection<?>> argumentMatcher) {
        Assertions.assertTrue((boolean)MetadataUtils.getValueProvider((DWType)weaveType).isPresent());
        ProviderReference reference = MetadataUtils.requireValueProvider((DWType)weaveType);
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)expectedName));
        MatcherAssert.assertThat((Object)reference.getArguments(), argumentMatcher);
    }

    public static void assertDescription(DWType weaveType, String expectedDescription) {
        Assertions.assertTrue((boolean)MetadataUtils.getDescription((DWType)weaveType).isPresent());
        Assertions.assertEquals((Object)expectedDescription, (Object)MetadataUtils.requireDescription((DWType)weaveType));
    }

    public static void assertMetadataProvider(TestConnectorModel connectorModel, DWType weaveType, String expectedName) {
        Assertions.assertTrue((boolean)MetadataUtils.getMetadataProvider((DWType)weaveType).isPresent());
        Assertions.assertEquals((Object)expectedName, (Object)MetadataUtils.requireMetadataProvider((DWType)weaveType).getName());
        Assertions.assertNotNull((Object)connectorModel.getMetadataProvider(expectedName));
    }

    public static void assertLabel(DWType weaveType, String expected) {
        MatcherAssert.assertThat((Object)MetadataUtils.getLabel((DWType)weaveType).isPresent(), (Matcher)Matchers.is((Object)true));
        Assertions.assertEquals((Object)expected, (Object)MetadataUtils.requireLabel((DWType)weaveType));
    }

    public static void assertLabel(org.mule.weave.v2.api.tooling.ts.ObjectType weaveType, String fieldName, String expected) {
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)fieldName).isPresent(), (Matcher)Matchers.is((Object)true));
        DWType field = DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)fieldName).getValue();
        MatcherAssert.assertThat((Object)MetadataUtils.getLabel((DWType)field).isPresent(), (Matcher)Matchers.is((Object)true));
        Assertions.assertEquals((Object)expected, (Object)TestUtils.requireMetadataLabelOnFieldValue(weaveType, fieldName));
    }

    public static void assertFormat(org.mule.weave.v2.api.tooling.ts.ObjectType weaveType, String fieldName, String expectedFormat) {
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)fieldName).isPresent(), (Matcher)Matchers.is((Object)true));
        DWType field = DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType, (String)fieldName).getValue();
        MatcherAssert.assertThat((Object)MetadataUtils.getFormat((DWType)field).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)field), (Matcher)Matchers.is((Object)expectedFormat));
    }

    public static void assertTypeId(DWType weaveType, String expectedTypeId) {
        Assertions.assertTrue((boolean)MetadataUtils.getTypeId((DWType)weaveType).isPresent());
        String actual = MetadataUtils.requireTypeId((DWType)weaveType);
        Assertions.assertEquals((Object)expectedTypeId, (Object)actual);
    }

    public static void assertEnumLabels(DWType weaveType, List<String> expected) {
        Optional enumLabelsMetadata = MetadataUtils.getEnumLabels((DWType)weaveType);
        Assertions.assertTrue((boolean)enumLabelsMetadata.isPresent());
        HashSet enumLabels = new HashSet((Collection)enumLabelsMetadata.get());
        Assertions.assertEquals((int)expected.size(), (int)enumLabels.size());
        for (String e : expected) {
            Assertions.assertTrue((boolean)enumLabels.contains(e));
        }
    }

    public static void assertSemanticTerms(DWType weaveType, List<String> expected) {
        Optional semanticTermsMetadata = MetadataUtils.getSemanticTerms((DWType)weaveType);
        Assertions.assertTrue((boolean)semanticTermsMetadata.isPresent());
        Set semanticTerms = (Set)semanticTermsMetadata.get();
        Assertions.assertEquals((int)expected.size(), (int)semanticTerms.size());
        for (String e : expected) {
            Assertions.assertTrue((boolean)semanticTerms.contains(e));
        }
    }

    public static void assertSemanticTerms(DWType weaveType, String fieldName, List<String> expected) {
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType), (String)fieldName).isPresent(), (Matcher)Matchers.is((Object)true));
        DWType field = DWTypeUtils.requireFieldByName((org.mule.weave.v2.api.tooling.ts.ObjectType)((org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType), (String)fieldName).getValue();
        TestUtils.assertSemanticTerms(field, expected);
    }

    public static org.mule.weave.v2.api.tooling.ts.ObjectType emptyObject() {
        return EMPTY_OBJECT;
    }

    private static <T> Seq<T> emptySeq() {
        return JavaConverters.collectionAsScalaIterable(List.of()).toSeq();
    }

    public static interface ObjectFieldTypeAssertion {
        public void assertField(KeyValuePairType var1);
    }
}

