%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::metadata::Builder
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::Trigger

var objectTypeValueProvider: ValueProvider<{}, {}, String, {}, {}> =
    (params, conn) -> success([
    {
      value : "Account",
      displayValue: {
        label: ""
      }
    },
    {
      value : "Order",
      displayValue: {
        label: ""
      }
    }
  ])

var orderType : TypeValueDefinition =
    createObjectTypeValueDefinition("Order")
      withField
        createField("orderId",createStringTypeValueDefinition(), true)
      withField
        createField("description",createStringTypeValueDefinition(), false)

var metadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(orderType)

type Record = {
   objectType: @Description(value = "The object type to create") @ValuesFrom(value = { name: "objectTypeValueProvider" }) String,
   record: @Description(value = "The record structure") @MetadataProvider(value = { name: "metadataProvider", arguments: { objectType: "objectType" } }) Object
}

var createRecordOperation: Operation<Record, @MetadataProvider(value = { name: "metadataProvider", arguments: {"objectType": "/objectType" } }) Object, ResultFailure<{}, Error>, HttpConnection> = {
    name: "createRecordOperation",
    displayName: "Create Record",
    executor: (parameter, connection) -> success({})
}

// just for testing parameters resolution
var createRecordOperation2: Operation<Record, @With(value = {"#pathToType": "/objectType"}) @MetadataProvider(value = { name: "metadataProvider", arguments: { objectType: "#pathToType" } }) Object, ResultFailure<{}, Error>, HttpConnection> = {
    name: "createRecordOperation",
    displayName: "Create Record",
    executor: (parameter, connection) -> success({})
}


var createMetadataProvider: MetadataProviderExecutor<{objectType: String}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(orderType)

type InputParameters = @With(value = { anotherField: "anotherField" }) {
    issueId : String,
    projectId : String,
    anotherField: String,
    fields : @MetadataProvider(value = { name: "createMetadataProvider", arguments: { issue: "issueId", project: "/projectId", another: "#anotherField" } }) Object
}

// just for testing parameters resolution
var createIssueOperation : Operation<InputParameters, String, ResultFailure<{}, Error>, HttpConnection> = {
    name: "createIssueOperation",
    displayName: "Create Issue",
    executor: (parameter, connection) -> success("success")
}

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

type CuratedRecord = {
    objectType: Record.objectType
}

var getRecords = {
                 name: "getRecords",
                 displayName: "getRecords",
                 executor: (parameter: Record, connection: HttpConnection): Result<String, ResultFailure<{}, Error>> ->
                    success("success")
               }

type DynamicEvent = @MetadataProvider(value = { name: "metadataProvider", arguments: { objectType: "/objectType" } }) Object
type CreateRecordForTriggerOperationOutput={identifier?:String, events?: Array<DynamicEvent>}

var createRecordForTriggerOperation : Operation<Record, CreateRecordForTriggerOperationOutput, ResultFailure<{}, Error>,HttpConnection> = {
    name: "createRecordForTriggerOperation",
    displayName: "Create Record For Trigger",
    executor: (parameter, connection) -> success({})
}

var dynamicTriggerStrategy:TriggerStrategy<CreateRecordForTriggerOperationOutput, DynamicEvent, DynamicEvent, String> =
{
          items: (result) -> result.events!,
          item: (item) -> item,
          watermark: (result, item) -> item.orderId! as String,
          identity: (item) -> item.orderId! as String,
          watermarkCompareTo: DefaultWatermarkComparison
      }

var triggers = {
  onNewRecordTrigger: {
      name: "onNewRecordTrigger",
      displayName: "On new record Trigger",
      metadata: {
          order: "ASC",
          paginated: false
      },
      strategy: {
          items: (result) -> result.body!,
          item: (item) -> item,
          watermark: (result, item) -> item.id,
          identity: (item) -> item.id as String,
          watermarkCompareTo: DefaultWatermarkComparison
      },
      operation: getRecords,
      inputMapper: (param: CuratedRecord, watermark: Number) -> {objectType: param.objectType, record: {}}
  },
  onNewRecordNoMapperTrigger: {
      name: "onNewRecordNoMapperTrigger",
      displayName: "On new record Trigger",
      metadata: {
          order: "ASC",
          paginated: false
      },
      strategy: dynamicTriggerStrategy,
      operation: createRecordForTriggerOperation
  }
}



@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var basicAuthConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
                              (parameter) -> parameter,
                              (parameter) -> {baseUri: "http://localhost"
                              }
)

@TestConnector()
var connector = {
    name: "DataWeaveExtension",
    displayName: "Data Weave Extension",
    connections: {basicAuth: basicAuthConnection},
    testConnection: testConnection,
    operations: {
       createRecordOperation: createRecordOperation,
       createRecordOperation2: createRecordOperation2,
       createIssueOperation: createIssueOperation
    },
    valueProviders: {
        objectTypeValueProvider: objectTypeValueProvider
    },
    metadataProviders: {
      metadataProvider : metadataProvider,
      createMetadataProvider : createMetadataProvider
    },
    triggers: {
        onNewRecordTrigger: triggers.onNewRecordTrigger,
        onNewRecordNoMapperTrigger: triggers.onNewRecordNoMapperTrigger
    }
}
