/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationManager;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.SimpleReferenceType;
import org.mule.weave.v2.ts.TypeHelper;
import org.mule.weave.v2.ts.TypeSelectorType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.List;

public class WeaveTypeSimplifier {
    private WeaveTypeSimplifier() {
    }

    public static DWType simplifyWeaveType(DWType weaveType) {
        return WeaveTypeSimplifier.simplifyWeaveType((WeaveType)weaveType);
    }

    public static WeaveType simplifyWeaveType(WeaveType weaveType) {
        if (weaveType instanceof ObjectType) {
            return WeaveTypeSimplifier.preserveMetadata(WeaveTypeSimplifier.resolveObjectType(weaveType), weaveType);
        }
        if (weaveType instanceof IntersectionType) {
            return WeaveTypeSimplifier.simplifyWeaveType(WeaveTypeSimplifier.preserveMetadata(WeaveTypeSimplifier.resolveIntersection(weaveType), weaveType));
        }
        if (weaveType instanceof SimpleReferenceType) {
            SimpleReferenceType ref = (SimpleReferenceType)weaveType;
            return WeaveTypeSimplifier.preserveMetadata(WeaveTypeSimplifier.simplifyWeaveType(ref.resolveType()), weaveType);
        }
        if (weaveType instanceof UnionType) {
            TypeHelper typeHelper = new TypeHelper(new ParsingNotificationManager());
            return WeaveTypeSimplifier.preserveMetadata(typeHelper.resolveUnion(weaveType), weaveType);
        }
        if (weaveType instanceof TypeSelectorType) {
            TypeSelectorType typeSelectorType = (TypeSelectorType)weaveType;
            return WeaveTypeSimplifier.preserveMetadata(WeaveTypeSimplifier.simplifyWeaveType(typeSelectorType.resolveType()), weaveType);
        }
        if (weaveType instanceof ArrayType) {
            TypeHelper typeHelper = new TypeHelper(new ParsingNotificationManager());
            WeaveType of = (WeaveType)typeHelper.getArrayType(weaveType).map(t -> WeaveTypeSimplifier.preserveMetadata(WeaveTypeSimplifier.simplifyWeaveType(t), weaveType)).get();
            return new ArrayType(of);
        }
        return weaveType;
    }

    public static WeaveType preserveMetadata(WeaveType weaveType, WeaveType originalWeaveType) {
        HashSet<String> names = new HashSet<String>();
        for (DWMetadata metadata : weaveType.getTypeMetadata()) {
            names.add(metadata.getName());
        }
        for (DWMetadata metadata : originalWeaveType.getTypeMetadata()) {
            if (names.contains(metadata.getName())) continue;
            weaveType.withMetadata((Metadata)metadata);
        }
        return weaveType;
    }

    private static WeaveType resolveObjectType(WeaveType weaveType) {
        if (!(weaveType instanceof ObjectType)) {
            return weaveType;
        }
        ObjectType objectType = (ObjectType)weaveType;
        java.util.List<KeyValuePairType> newProperties = Arrays.stream(objectType.getProperties()).map(KeyValuePairType.class::cast).map(kv -> new KeyValuePairType(kv.key(), WeaveTypeSimplifier.simplifyWeaveType(kv.value()), kv.optional(), kv.repeated())).toList();
        ObjectType resultObjectType = new ObjectType((Seq)JavaConverters.asScalaBuffer(newProperties).toList(), objectType.isClosed(), objectType.isOrdered());
        for (DWMetadata metadata : objectType.getTypeMetadata()) {
            resultObjectType = resultObjectType.withMetadata((Metadata)metadata);
        }
        return resultObjectType;
    }

    public static WeaveType resolveIntersection(WeaveType weaveType) {
        if (!(weaveType instanceof IntersectionType)) {
            return weaveType;
        }
        IntersectionType intersectionType = (IntersectionType)weaveType;
        ArrayList<WeaveType> intersectionTypesList = new ArrayList<WeaveType>();
        for (DWType wt : intersectionType.intersectionOf()) {
            intersectionTypesList.add(WeaveTypeSimplifier.simplifyWeaveType((WeaveType)wt));
        }
        List intersectionTypes = JavaConverters.asScalaBuffer(intersectionTypesList).toList();
        TypeHelper helper = new TypeHelper(new ParsingNotificationManager());
        return helper.resolveIntersection((Seq)intersectionTypes);
    }

    public static WeaveType resolveIntersectionWithoutSimplification(WeaveType weaveType) {
        if (!(weaveType instanceof IntersectionType)) {
            return weaveType;
        }
        IntersectionType intersectionType = (IntersectionType)weaveType;
        ArrayList<WeaveType> intersectionTypesList = new ArrayList<WeaveType>();
        for (DWType wt : intersectionType.intersectionOf()) {
            intersectionTypesList.add((WeaveType)wt);
        }
        List intersectionTypes = JavaConverters.asScalaBuffer(intersectionTypesList).toList();
        TypeHelper helper = new TypeHelper(new ParsingNotificationManager());
        return helper.resolveIntersection((Seq)intersectionTypes);
    }
}

