/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataProviderInjectionModelLoaderTest
extends AbstractConnectivityModelTest {
    @Test
    void loadsFieldMetadata() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::Connector");
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"DataWeaveExtension"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Data Weave Extension"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)connectorModel.getOperations().size(), (Matcher)Matchers.equalTo((Object)3));
        OperationModel operation = connectorModel.getOperations().get(0);
        MetadataProviderInjectionModelLoaderTest.assertOutputMetadataProvider(operation);
        this.assertOutputMetadataProviderWithOperationAPI(operation);
        this.assertOutputMetadataProviderWithOperationAPI(connectorModel.getOperations().get(1));
        this.checkParametersResolution(connectorModel.getOperations().get(2));
        MatcherAssert.assertThat((Object)operation.getName(), (Matcher)Matchers.equalTo((Object)"createRecordOperation"));
        DWType inputType = TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType objectType = (ObjectType)inputType;
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"objectType").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType objectTypeField = DWTypeUtils.requireFieldByName((ObjectType)objectType, (String)"objectType").getValue();
        Assertions.assertEquals((int)2, (int)objectTypeField.getTypeMetadata().length);
        TestUtils.assertValueProvider(connectorModel, objectTypeField, "objectTypeValueProvider", Matchers.is((Matcher)Matchers.empty()));
        TestUtils.assertDescription(objectTypeField, "The object type to create");
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)objectType, (String)"record").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType recordField = DWTypeUtils.requireFieldByName((ObjectType)objectType, (String)"record").getValue();
        Assertions.assertEquals((int)2, (int)recordField.getTypeMetadata().length);
        TestUtils.assertMetadataProvider(connectorModel, recordField, "metadataProvider");
        ProviderReference providerReference = MetadataUtils.requireMetadataProvider((DWType)recordField);
        MatcherAssert.assertThat((Object)providerReference.getArguments().size(), (Matcher)Matchers.equalTo((Object)1));
        ProviderArgument objectTypeMapping = (ProviderArgument)providerReference.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        providerReference = (ProviderReference)operation.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record")).get();
        MatcherAssert.assertThat((Object)providerReference.getName(), (Matcher)Matchers.equalTo((Object)"metadataProvider"));
        MatcherAssert.assertThat((Object)providerReference.getArguments().size(), (Matcher)Matchers.equalTo((Object)1));
        objectTypeMapping = (ProviderArgument)providerReference.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        Assertions.assertFalse((boolean)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).isRelative());
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        TestUtils.assertDescription(recordField, "The record structure");
        MatcherAssert.assertThat((Object)connectorModel.getTriggers().size(), (Matcher)Matchers.equalTo((Object)2));
        MetadataProviderInjectionModelLoaderTest.assertTriggerMetadataProvider(connectorModel.getTriggers().get(0), "onNewRecordTrigger", connectorModel);
        MetadataProviderInjectionModelLoaderTest.assertTriggerMetadataProvider(connectorModel.getTriggers().get(1), "onNewRecordNoMapperTrigger", connectorModel);
        MetadataProviderInjectionModelLoaderTest.assertTriggerInputMetadataProvider(connectorModel.getTriggers().get(1));
        MetadataProviderInjectionModelLoaderTest.assertTriggerOutputMetadataProvider(connectorModel.getTriggers().get(1));
    }

    private static void assertTriggerMetadataProvider(TriggerModel triggerModel, String name, TestConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)triggerModel.getName(), (Matcher)Matchers.equalTo((Object)name));
        ObjectType inputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)triggerModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)DWTypeUtils.getFieldByName((ObjectType)inputType, (String)"objectType").isPresent(), (Matcher)Matchers.is((Object)true));
        DWType triggerObjectTypeField = DWTypeUtils.requireFieldByName((ObjectType)inputType, (String)"objectType").getValue();
        Assertions.assertEquals((int)2, (int)triggerObjectTypeField.getTypeMetadata().length);
        TestUtils.assertValueProvider(connectorModel, triggerObjectTypeField, "objectTypeValueProvider", Matchers.is((Matcher)Matchers.empty()));
        TestUtils.assertDescription(triggerObjectTypeField, "The object type to create");
    }

    private static void assertProviderReference(ProviderReference providerReference) {
        MatcherAssert.assertThat((Object)providerReference.getName(), (Matcher)Matchers.equalTo((Object)"metadataProvider"));
        MatcherAssert.assertThat((Object)providerReference.getArguments().size(), (Matcher)Matchers.equalTo((Object)1));
        ProviderArgument objectTypeMapping = (ProviderArgument)providerReference.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
    }

    private static void assertTriggerInputMetadataProvider(TriggerModel triggerModel) {
        ProviderReference inputMetadataProvider = (ProviderReference)triggerModel.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record")).get();
        MetadataProviderInjectionModelLoaderTest.assertProviderReference(inputMetadataProvider);
    }

    private static void assertTriggerOutputMetadataProvider(TriggerModel triggerModel) {
        ProviderReference outputMetadataProvider = MetadataUtils.requireMetadataProvider((DWType)triggerModel.getOutputType().getDataType());
        MetadataProviderInjectionModelLoaderTest.assertProviderReference(outputMetadataProvider);
    }

    private static void assertOutputMetadataProvider(OperationModel operation) {
        ProviderReference outputMetadataProvider = MetadataUtils.requireMetadataProvider((DWType)operation.getOutputType().getDataType());
        MetadataProviderInjectionModelLoaderTest.assertProviderReference(outputMetadataProvider);
    }

    private void assertOutputMetadataProviderWithOperationAPI(OperationModel operation) {
        ProviderReference outputMetadataProvider = (ProviderReference)operation.getOutputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/")).get();
        MatcherAssert.assertThat((Object)outputMetadataProvider.getName(), (Matcher)Matchers.equalTo((Object)"metadataProvider"));
        MatcherAssert.assertThat((Object)outputMetadataProvider.getArguments().size(), (Matcher)Matchers.equalTo((Object)1));
        ProviderArgument objectTypeMapping = (ProviderArgument)outputMetadataProvider.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
        Assertions.assertFalse((boolean)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).isRelative());
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"objectType"}));
    }

    private void checkParametersResolution(OperationModel operation) {
        ProviderReference metadataProvider = (ProviderReference)operation.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/fields")).get();
        MatcherAssert.assertThat((Object)metadataProvider.getName(), (Matcher)Matchers.equalTo((Object)"createMetadataProvider"));
        MatcherAssert.assertThat((Object)metadataProvider.getArguments().size(), (Matcher)Matchers.equalTo((Object)3));
        ProviderArgument objectTypeMapping = (ProviderArgument)metadataProvider.getArguments().get(0);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"issueId"}));
        Assertions.assertFalse((boolean)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).isRelative());
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"issue"}));
        objectTypeMapping = (ProviderArgument)metadataProvider.getArguments().get(1);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"projectId"}));
        Assertions.assertFalse((boolean)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).isRelative());
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"project"}));
        objectTypeMapping = (ProviderArgument)metadataProvider.getArguments().get(2);
        MatcherAssert.assertThat((Object)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"anotherField"}));
        Assertions.assertFalse((boolean)((ObjectFieldSelector)objectTypeMapping.getInputSelector()).isRelative());
        MatcherAssert.assertThat((Object)objectTypeMapping.getParameterSelector().getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"another"}));
    }
}

