/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ConnectorExecutionException;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.interpreter.Result;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModelLoaderFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class ModelInterpreter001Test {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private static final LanguageModelLoader<TestConnectorModel, TestConnectorModel.Builder> modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new TestConnectorModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    public static final String DATAWEAVE_EXECUTION_FAILURE_MESSAGE = "Dataweave execution failed: org.mule.weave.v2.parser.phase.CompilationException: Unable to resolve reference of: `modelReferenceThat::doesNotExist`";
    private final ModelInterpreterConfig modelInterpreterConfig = new ModelInterpreterConfig.Builder().base64EncodeTriggerState(true).build();
    protected final ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveEngine, this.modelInterpreterConfig);
    private static final TestConnectorModel CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("test001::Connector");
    private static final Map<String, Object> connectionInfo = ModelInterpreter001Test.createConnectionInfo();

    ModelInterpreter001Test() {
    }

    private static Map<String, Object> createConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://api.acme.com/v1");
        connectionInfo.put("user", "jdoe");
        connectionInfo.put("pass", "secret");
        return connectionInfo;
    }

    @Test
    void testConnection() {
        TestConnectionModel testConnectionModel = CONNECTOR_MODEL.getTestConnection();
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        ConnectionValidationResult result = this.modelInterpreter.testConnection(testConnectionModel, (BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        Connection<Model> otherConnectionClass = new Connection<Model>(new Model("module::x"){}, Map.of()){};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$testConnection$0(otherConnectionClass));
    }

    @Test
    void resolveConnectionExtensions() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        List result = this.modelInterpreter.executeResolveConnectionExtensions((BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat(((Map)result.get(0)).get("name"), (Matcher)CoreMatchers.equalTo((Object)"Customauthheader"));
        MatcherAssert.assertThat(((Map)result.get(0)).get("value"), (Matcher)CoreMatchers.equalTo((Object)"myValue,user:jdoe"));
        MatcherAssert.assertThat(((Map)result.get(0)).get("in"), (Matcher)CoreMatchers.equalTo((Object)"header"));
    }

    @Test
    void executesOperation() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("updateAccountById");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter001Test.createUpdateAccountParams("123"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Map updateAccountResult = (Map)operationResult.getValue();
        MatcherAssert.assertThat(updateAccountResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(updateAccountResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat(updateAccountResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        MatcherAssert.assertThat(updateAccountResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        ModelInterpreter001Test.assertAccount((Map)updateAccountResult.get("body"), "123", "ACME", "support@acme.com");
    }

    @Test
    void executesOperationUsingNewAPI() throws IOException {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("updateAccountById");
        OperationResult operationResult = this.modelInterpreter.executeOperation((Connection)Connection.of((BaseConnectionProviderModel)connectionProviderModel, connectionInfo), (BaseExecutableComponentModel)operationModel, ModelInterpreter001Test.createUpdateAccountParams("123"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (Content updateAccountContent = (Content)operationResult.getValue();){
            Map updateAccountResult = (Map)updateAccountContent.get();
            MatcherAssert.assertThat(updateAccountResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
            MatcherAssert.assertThat(updateAccountResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat(updateAccountResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
            MatcherAssert.assertThat(updateAccountResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
            ModelInterpreter001Test.assertAccount((Map)updateAccountResult.get("body"), "123", "ACME", "support@acme.com");
            String updateAccountRaw = new String(((InputStream)updateAccountContent.raw().orElseThrow()).readAllBytes(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)updateAccountRaw, (Matcher)CoreMatchers.equalTo((Object)"{\"id\":\"123\",\"name\":\"ACME\",\"email\":\"support@acme.com\"}"));
            MatcherAssert.assertThat((Object)updateAccountContent.rawContentType(), (Matcher)CoreMatchers.equalTo(Optional.of("application/json; charset=utf-8")));
            MatcherAssert.assertThat((Object)updateAccountContent.getTransportAttributes(), (Matcher)CoreMatchers.equalTo(Optional.of(Map.of("kind", "http", "statusCode", 200, "headers", Map.of(), "cookies", Map.of()))));
        }
    }

    @Test
    void executesOperationWithCustomError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("updateAccountById");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter001Test.createUpdateAccountParams("-1"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        Content updateAccountContent = (Content)operationResult.getErrorValue().asContent().get();
        Object updateAccountResultFromContent = updateAccountContent.get();
        Assertions.assertTrue((boolean)updateAccountContent.raw().isEmpty());
        Assertions.assertTrue((boolean)updateAccountContent.rawContentType().isEmpty());
        MatcherAssert.assertThat((Object)operationResult.getErrorValue().getCause(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
        Map updateAccountResult = (Map)operationResult.getErrorValue().getValue();
        MatcherAssert.assertThat((Object)updateAccountResult, (Matcher)CoreMatchers.equalTo((Object)updateAccountResultFromContent));
        MatcherAssert.assertThat(updateAccountResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(updateAccountResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)400));
        MatcherAssert.assertThat(updateAccountResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        MatcherAssert.assertThat(updateAccountResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map body = (Map)updateAccountResult.get("body");
        MatcherAssert.assertThat((Object)body.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(body.get("error"), (Matcher)CoreMatchers.equalTo((Object)"invalidAccountId"));
        MatcherAssert.assertThat(body.get("detail"), (Matcher)CoreMatchers.equalTo((Object)"accountId cannot be a negative value"));
    }

    @Test
    void executesOperationWithNoErrorMessage() throws IOException {
        Object updateAccountResultFromContent;
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("updateAccountById");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter001Test.createUpdateAccountParams("999"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)operationResult.getErrorValue().getCause(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
        try (Content updateAccountContent = (Content)operationResult.getErrorValue().asContent().orElseThrow();){
            updateAccountResultFromContent = updateAccountContent.get();
            String updateAccountResultRaw = new String(((InputStream)updateAccountContent.raw().orElseThrow()).readAllBytes(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)updateAccountResultRaw, (Matcher)CoreMatchers.equalTo((Object)"{}"));
            MatcherAssert.assertThat((Object)updateAccountContent.rawContentType(), (Matcher)CoreMatchers.equalTo(Optional.of("application/json; charset=utf-8")));
            MatcherAssert.assertThat((Object)updateAccountContent.getTransportAttributes(), (Matcher)CoreMatchers.equalTo(Optional.of(Map.of("kind", "http", "statusCode", 404, "headers", Map.of(), "cookies", Map.of()))));
        }
        Map updateAccountResult = (Map)operationResult.getErrorValue().getValue();
        MatcherAssert.assertThat((Object)updateAccountResult, (Matcher)CoreMatchers.equalTo((Object)updateAccountResultFromContent));
        MatcherAssert.assertThat(updateAccountResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(updateAccountResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)404));
        MatcherAssert.assertThat(updateAccountResult.get("statusText"), (Matcher)CoreMatchers.equalTo((Object)"Not Found"));
        MatcherAssert.assertThat(updateAccountResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        MatcherAssert.assertThat(updateAccountResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map body = (Map)updateAccountResult.get("body");
        MatcherAssert.assertThat((Object)body.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void executesOperationWithUncheckedUnexpectedError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "another-one"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ModelInterpreter001Test.assertUncheckedErrorValue(operationResult.getErrorValue(), "__UNEXPECTED", "unexpected", "unexpected", "unexpected-category");
    }

    @Test
    void executesOperationWithUncheckedDefaultError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "default"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ModelInterpreter001Test.assertUncheckedErrorValue(operationResult.getErrorValue(), "__HTTP_DEFAULT", "default", "default", "default-category");
    }

    @Test
    void executesOperationWithUncheckedDefault4XXError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "4xx"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ModelInterpreter001Test.assertUncheckedErrorValue(operationResult.getErrorValue(), "__HTTP_4XX", "4xx", "4XX", "4xx-category");
    }

    @Test
    void executesOperationWithUncheckedDefault5XXError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "5xx"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ModelInterpreter001Test.assertUncheckedErrorValue(operationResult.getErrorValue(), "__HTTP_5XX", "5xx", "5XX", "5xx-category");
    }

    @Test
    void executesOperationWithUncheckedErrorAndSerializesResult() throws IOException, ClassNotFoundException {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "another-one"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ResultError lazyErrorValue = operationResult.getErrorValue();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
        objOutStream.writeObject(lazyErrorValue);
        objOutStream.flush();
        objOutStream.close();
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        ObjectInputStream objInSteam = new ObjectInputStream(inStream);
        ResultError errorValue = (ResultError)objInSteam.readObject();
        objInSteam.close();
        ModelInterpreter001Test.assertUncheckedErrorValue(errorValue, "__UNEXPECTED", "unexpected", "unexpected", "unexpected-category");
    }

    private static void assertUncheckedErrorValue(ResultError errorValue, String category, String reason, String causeKind, String causeCategory) {
        MatcherAssert.assertThat((Object)errorValue.getKind(), (Matcher)CoreMatchers.equalTo((Object)"__UNCHECKED"));
        MatcherAssert.assertThat((Object)errorValue.getCategories(), (Matcher)CoreMatchers.equalTo(Set.of(category)));
        MatcherAssert.assertThat((Object)errorValue.getValue(), (Matcher)CoreMatchers.equalTo(Map.of("reason", reason)));
        MatcherAssert.assertThat((Object)errorValue.getDescription(), (Matcher)CoreMatchers.equalTo(Optional.of("An unchecked error occurred. Check the `cause` field for more details")));
        ResultError cause = (ResultError)Assertions.assertDoesNotThrow(() -> (ResultError)errorValue.getCause().orElseThrow());
        MatcherAssert.assertThat((Object)cause.getKind(), (Matcher)CoreMatchers.equalTo((Object)causeKind));
        MatcherAssert.assertThat((Object)cause.getCategories(), (Matcher)CoreMatchers.equalTo(Set.of(causeCategory)));
        MatcherAssert.assertThat((Object)cause.getValue(), (Matcher)CoreMatchers.equalTo(Map.of("reason", reason)));
        MatcherAssert.assertThat((Object)cause.getDescription(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
        MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
    }

    @Test
    void executesOperationWithException() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("testFailures");
        ConnectorExecutionException e = (ConnectorExecutionException)Assertions.assertThrows(ConnectorExecutionException.class, () -> this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, Map.of("reason", "exception")));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Connector failed when executing operation 'testFailures': Exception message"));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)e.getExecutionException())));
    }

    @Test
    void executesPaginatedOperation() throws IOException {
        Map nextPage;
        List items;
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("getAccounts");
        OperationResult page1 = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter001Test.createPaginationParams(0, 2));
        MatcherAssert.assertThat((Object)page1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (Page getAccountsResult = (Page)page1.getValue();){
            Iterator z = (Iterator)getAccountsResult.getRawItems().orElseThrow();
            MatcherAssert.assertThat((Object)z.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            try (Content c = (Content)z.next();){
                ModelInterpreter001Test.assertAccount((Map)c.get(), "1", "One", "one@acme.com");
                MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)CoreMatchers.is(Optional.of("application/json")));
                try (InputStream raw = (InputStream)c.raw().orElseThrow();){
                    MatcherAssert.assertThat((Object)new String(raw.readAllBytes(), StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"{\n  \"id\": \"1\",\n  \"name\": \"One\",\n  \"email\": \"one@acme.com\"\n}"));
                }
            }
            MatcherAssert.assertThat((Object)z.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            c = (Content)z.next();
            try {
                ModelInterpreter001Test.assertAccount((Map)c.get(), "2", "Two", "two@acme.com");
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            MatcherAssert.assertThat((Object)z.hasNext(), (Matcher)CoreMatchers.is((Object)false));
            Assertions.assertThrows(NoSuchElementException.class, () -> {
                try (Content c = (Content)z.next();){
                    System.err.println("got: " + String.valueOf(c.get()));
                }
            });
            MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
            items = getAccountsResult.getItems();
            MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
            ModelInterpreter001Test.assertAccount((Map)items.get(0), "1", "One", "one@acme.com");
            ModelInterpreter001Test.assertAccount((Map)items.get(1), "2", "Two", "two@acme.com");
            nextPage = (Map)getAccountsResult.getNextPage().orElseThrow();
            this.assertNextPage(nextPage, 2, 2);
        }
        OperationResult page2 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, (Object)nextPage);
        MatcherAssert.assertThat((Object)page2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page2.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (Page getAccountsResult = ((Result)page2.getValue()).asPage();){
            MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
            items = getAccountsResult.getItems();
            MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
            ModelInterpreter001Test.assertAccount((Map)items.get(0), "3", "Three", "three@acme.com");
            ModelInterpreter001Test.assertAccount((Map)items.get(1), "4", "Four", "four@acme.com");
            nextPage = (Map)getAccountsResult.getNextPage().orElseThrow();
            this.assertNextPage(nextPage, 4, 2);
        }
        OperationResult page3 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, (Object)nextPage);
        MatcherAssert.assertThat((Object)((Result)page3.getValue()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page3.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (Page getAccountsResult = ((Result)page3.getValue()).asPage();){
            MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)Matchers.hasSize((int)0));
            MatcherAssert.assertThat((Object)getAccountsResult.getNextPage(), (Matcher)CoreMatchers.is(Optional.empty()));
        }
    }

    @Test
    void executesTrigger() throws IOException {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        TriggerModel triggerModel = CONNECTOR_MODEL.getTrigger("getUsersTrigger");
        HashMap<String, Integer> triggerParams = new HashMap<String, Integer>();
        triggerParams.put("since", 20200101);
        Serializable initialWatermark = this.modelInterpreter.getInitialWatermark((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, triggerParams);
        OperationResult triggerResult = this.modelInterpreter.executeTrigger((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, (Object)initialWatermark, triggerParams);
        MatcherAssert.assertThat((Object)triggerResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage triggerPage = (TriggerPage)triggerResult.getValue();){
            List items = triggerPage.getItems();
            this.assertUser((TriggerItem)items.get(0), 1, "pepe", "p@sales.com", 20200102, 20200102, "1", true);
            this.assertUser((TriggerItem)items.get(1), 2, "pepito", "pe@sales.com", 20200105, 20200105, "2", true);
            this.assertUser((TriggerItem)items.get(2), 3, "pepillo", "pep@sales.com", 20210517, 20210517, "3", true);
            try (Content content = (Content)((TriggerItem)items.get(0)).getContent().orElseThrow();){
                ModelInterpreter001Test.assertUserItemValue((Map)content.get(), "pepe", "p@sales.com", 20200102, 1);
                MatcherAssert.assertThat((Object)new String(((InputStream)content.raw().orElseThrow()).readAllBytes(), StandardCharsets.UTF_8), (Matcher)CoreMatchers.is((Object)"{\n  \"id\": 1,\n  \"name\": \"pepe\",\n  \"email\": \"p@sales.com\",\n  \"created_at\": 20200102\n}"));
            }
            Object greatestWatermarkObject = this.deserializeObject(triggerPage.getNextPoll().getGreatestWatermark());
            Object latestWatermarkObject = this.deserializeObject(triggerPage.getNextPoll().getLatestWatermark());
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20210517));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
            MatcherAssert.assertThat((Object)this.modelInterpreter.executeTriggerCompareWatermark((BaseExecutableComponentModel)triggerModel, (Serializable)((Object)"Mw=="), (Serializable)((Object)"Mg==")), (Matcher)CoreMatchers.is((Object)-1));
        }
    }

    @ParameterizedTest(name="base64encode: {0}")
    @ValueSource(booleans={true, false})
    void executesPaginatedTrigger(boolean base64EncodeTriggerState) {
        NextData nextData;
        Serializable latestWatermarkObject;
        Serializable greatestWatermarkObject;
        ModelInterpreterConfig modelInterpreterConfig = new ModelInterpreterConfig.Builder().base64EncodeTriggerState(base64EncodeTriggerState).build();
        ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveEngine, modelInterpreterConfig);
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        TriggerModel triggerModel = CONNECTOR_MODEL.getTrigger("getUsersTriggerPaginated");
        HashMap<String, Integer> triggerParams = new HashMap<String, Integer>();
        triggerParams.put("startDate", 20200101);
        Serializable initialWatermark = modelInterpreter.getInitialWatermark((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, triggerParams);
        OperationResult triggerResult = modelInterpreter.executeTrigger((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, (Object)initialWatermark, triggerParams);
        MatcherAssert.assertThat((Object)triggerResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage p = (TriggerPage)triggerResult.getValue();){
            this.assertUser((TriggerItem)p.getItems().get(0), 1, "pepe", "p@sales.com", 20200102, 20200102, "1", base64EncodeTriggerState);
            this.assertUser((TriggerItem)p.getItems().get(1), 2, "pepito", "pe@sales.com", 20200105, 20200105, "2", base64EncodeTriggerState);
            this.assertUser((TriggerItem)p.getItems().get(2), 3, "pepillo", "pep@sales.com", 20210517, 20210517, "3", base64EncodeTriggerState);
            Serializable greatestWatermark = p.getNextPoll().getGreatestWatermark();
            Serializable latestWatermark = p.getNextPoll().getLatestWatermark();
            greatestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(greatestWatermark) : greatestWatermark;
            latestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(latestWatermark) : latestWatermark;
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20210517));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
            nextData = p.getNextData();
        }
        OperationResult triggerSecondPageResult = modelInterpreter.executeTriggerNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, nextData);
        MatcherAssert.assertThat((Object)triggerSecondPageResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerSecondPageResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage p = (TriggerPage)triggerSecondPageResult.getValue();){
            this.assertUser((TriggerItem)p.getItems().get(0), 4, "juan", "j@sales.com", 20210519, 20210519, "4", base64EncodeTriggerState);
            this.assertUser((TriggerItem)p.getItems().get(1), 5, "perez", "perez@sales.com", 20211111, 20211111, "5", base64EncodeTriggerState);
            this.assertUser((TriggerItem)p.getItems().get(2), 6, "jose", "jose@sales.com", 20230609, 20230609, "6", base64EncodeTriggerState);
            Serializable greatestWatermark = p.getNextPoll().getGreatestWatermark();
            Serializable latestWatermark = p.getNextPoll().getLatestWatermark();
            greatestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(greatestWatermark) : greatestWatermark;
            latestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(latestWatermark) : latestWatermark;
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20230609));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
            nextData = p.getNextData();
        }
        OperationResult triggerThirdPageResult = modelInterpreter.executeTriggerNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, nextData);
        MatcherAssert.assertThat((Object)triggerThirdPageResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerThirdPageResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage p = (TriggerPage)triggerThirdPageResult.getValue();){
            MatcherAssert.assertThat((Object)p.getItems().size(), (Matcher)CoreMatchers.is((Object)0));
            Serializable greatestWatermark = p.getNextPoll().getGreatestWatermark();
            Serializable latestWatermark = p.getNextPoll().getLatestWatermark();
            greatestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(greatestWatermark) : greatestWatermark;
            latestWatermarkObject = base64EncodeTriggerState ? this.deserializeObject(latestWatermark) : latestWatermark;
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20230609));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
            MatcherAssert.assertThat((Object)p.getNextData().getNextPage().isPresent(), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }

    @Test
    void executesPaginatedTriggerStartedByOperationRequest() {
        NextData nextData;
        Object latestWatermarkObject;
        Object greatestWatermarkObject;
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        TriggerModel triggerModel = CONNECTOR_MODEL.getTrigger("getUsersTriggerPaginatedNoStartDate");
        HashMap triggerParams = new HashMap();
        Serializable initialWatermark = this.modelInterpreter.getInitialWatermark((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, triggerParams);
        OperationResult triggerResult = this.modelInterpreter.executeTrigger((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, (Object)initialWatermark, triggerParams);
        MatcherAssert.assertThat((Object)triggerResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage page = (TriggerPage)triggerResult.getValue();){
            List items = page.getItems();
            this.assertUser((TriggerItem)items.get(0), 1, "pepe", "p@sales.com", 20200102, 20200102, "1", true);
            this.assertUser((TriggerItem)items.get(1), 2, "pepito", "pe@sales.com", 20200105, 20200105, "2", true);
            this.assertUser((TriggerItem)items.get(2), 3, "pepillo", "pep@sales.com", 20210517, 20210517, "3", true);
            greatestWatermarkObject = this.deserializeObject(page.getNextPoll().getGreatestWatermark());
            latestWatermarkObject = this.deserializeObject(page.getNextPoll().getLatestWatermark());
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20210517));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
            nextData = page.getNextData();
        }
        OperationResult triggerSecondPageResult = this.modelInterpreter.executeTriggerNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, nextData);
        MatcherAssert.assertThat((Object)triggerSecondPageResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)triggerSecondPageResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        try (TriggerPage page = (TriggerPage)triggerSecondPageResult.getValue();){
            this.assertUser((TriggerItem)page.getItems().get(0), 4, "juan", "j@sales.com", 20210519, 20210519, "4", true);
            this.assertUser((TriggerItem)page.getItems().get(1), 5, "perez", "perez@sales.com", 20211111, 20211111, "5", true);
            this.assertUser((TriggerItem)page.getItems().get(2), 6, "jose", "jose@sales.com", 20230609, 20230609, "6", true);
            greatestWatermarkObject = this.deserializeObject(page.getNextPoll().getGreatestWatermark());
            latestWatermarkObject = this.deserializeObject(page.getNextPoll().getLatestWatermark());
            MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20230609));
            MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)CoreMatchers.equalTo((Object)20200101));
        }
    }

    @Test
    void serializationNullsTriggerTest() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        TriggerModel triggerModel = CONNECTOR_MODEL.getTrigger("getUsersTriggerPaginatedNoStartDate");
        OperationResult triggerSecondPageResult = this.modelInterpreter.executeTriggerNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)triggerModel, new NextData(new NextPoll(null, null), (Serializable)((Object)"bnVsbA==")));
        try (TriggerPage page = (TriggerPage)triggerSecondPageResult.getValue();){
            MatcherAssert.assertThat((Object)page.getNextPoll().getLatestWatermark(), (Matcher)CoreMatchers.equalTo(null));
        }
    }

    @Test
    void executesValueProvider() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        ValueProviderModel valueProvider = CONNECTOR_MODEL.getValueProvider("accountsValueProvider");
        OperationResult executionResult = this.modelInterpreter.executeValueProvider(connectionProviderModel, connectionInfo, valueProvider, ModelInterpreter001Test.createPaginationParams(0, 2));
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        List items = ((Page)executionResult.getValue()).getItems();
        MatcherAssert.assertThat((Object)items.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(0), "1", "One");
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(1), "2", "Two");
    }

    @Test
    void executesValueProviderError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        ValueProviderModel valueProvider = CONNECTOR_MODEL.getValueProvider("accountsValueProvider");
        OperationResult executionResult = this.modelInterpreter.executeValueProvider(connectionProviderModel, connectionInfo, valueProvider, ModelInterpreter001Test.createPaginationParams(-1, 2));
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)executionResult.getErrorValue().getCause(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
        Map updateAccountResult = (Map)executionResult.getErrorValue().getValue();
        MatcherAssert.assertThat(updateAccountResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(updateAccountResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)400));
        MatcherAssert.assertThat(updateAccountResult.get("statusText"), (Matcher)CoreMatchers.equalTo((Object)"Bad Request"));
        MatcherAssert.assertThat(updateAccountResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        MatcherAssert.assertThat(updateAccountResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map body = (Map)updateAccountResult.get("body");
        MatcherAssert.assertThat((Object)body.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void executesMetadataProvider() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        MetadataProviderModel provider = CONNECTOR_MODEL.getMetadataProvider("metadataProvider");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectType", "Account");
        OperationResult executionResult = this.modelInterpreter.executeMetadataProvider(connectionProviderModel, connectionInfo, provider, params);
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        DWType metadataType = (DWType)executionResult.getValue();
        MatcherAssert.assertThat((Object)((LiteralMetadataValue)((DWMetadata)metadataType.getTypeMetadata("typeId").get()).getValue()).getValue(), (Matcher)CoreMatchers.is((Object)"Account"));
        MatcherAssert.assertThat((Object)metadataType, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)metadataType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)metadataType).getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("accountId", NumberType.class, true), ObjectFieldMatcher.fieldLike("description", StringType.class, true)}));
        params = new HashMap();
        params.put("objectType", "Order");
        executionResult = this.modelInterpreter.executeMetadataProvider(connectionProviderModel, connectionInfo, provider, params);
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        metadataType = (DWType)executionResult.getValue();
        MatcherAssert.assertThat((Object)((LiteralMetadataValue)((DWMetadata)metadataType.getTypeMetadata("typeId").get()).getValue()).getValue(), (Matcher)CoreMatchers.is((Object)"Order"));
        MatcherAssert.assertThat((Object)metadataType, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)metadataType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        List<KeyValuePairType> fields = List.of(((ObjectType)metadataType).getProperties());
        MatcherAssert.assertThat(fields, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("orderId", StringType.class, true), ObjectFieldMatcher.fieldLike("description", StringType.class, false)}));
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.modelInterpreter.executeMetadataProvider(connectionProviderModel, connectionInfo, provider, Map.of("objectType", "OrderExtended")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Field products already exists"));
    }

    @Test
    void executesMetadataProviderError() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        MetadataProviderModel provider = CONNECTOR_MODEL.getMetadataProvider("metadataProvider");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectType", "any");
        OperationResult executionResult = this.modelInterpreter.executeMetadataProvider(connectionProviderModel, connectionInfo, provider, params);
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        ResultError error = executionResult.getErrorValue();
        MatcherAssert.assertThat((Object)error.getDescription(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
        MatcherAssert.assertThat(((Map)error.getValue()).get("errorMessage"), (Matcher)CoreMatchers.equalTo((Object)"error"));
        MatcherAssert.assertThat((Object)error.getKind(), (Matcher)CoreMatchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)error.getCategories().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)CoreMatchers.equalTo(Optional.empty()));
    }

    @Test
    void unhandledExceptionIsLoggedAsError() {
        LoggingService loggingService = (LoggingService)Mockito.mock(LoggingService.class);
        DataWeaveScriptingEngine engine = dataWeaveEngine.withLoggingService(loggingService);
        ModelInterpreter modelInterpreter = new ModelInterpreter(engine, new ModelInterpreterConfig.Builder().build());
        BaseExecutableComponentModel model = (BaseExecutableComponentModel)((BaseExecutableComponentModel.ExecutableComponentBuilder)((BaseExecutableComponentModel.ExecutableComponentBuilder)new BaseExecutableComponentModel.ExecutableComponentBuilder().withName("testModel")).withModelReference("modelReferenceThat::doesNotExist")).build();
        Assertions.assertThrows(CompilationException.class, () -> modelInterpreter.executeTriggerCompareWatermark(model, (Serializable)Integer.valueOf(1), (Serializable)Integer.valueOf(2)));
        ((LoggingService)Mockito.verify((Object)loggingService, (VerificationMode)Mockito.times((int)1))).logError(Mockito.contains((String)DATAWEAVE_EXECUTION_FAILURE_MESSAGE));
    }

    @Test
    void executesPaginatedValueProvider() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        ValueProviderModel valueProvider = CONNECTOR_MODEL.getValueProvider("accountsPaginatedValueProvider");
        OperationResult executionResult = this.modelInterpreter.executeValueProvider(connectionProviderModel, connectionInfo, valueProvider, ModelInterpreter001Test.createPaginationParams(0, 2));
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Page value = (Page)executionResult.getValue();
        List items = value.getItems();
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(0), "1", "One");
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(1), "2", "Two");
        Map nextPage = (Map)value.getNextPage().orElseThrow();
        this.assertNextPage(nextPage, 2, 2);
        executionResult = this.modelInterpreter.executeValueProviderNextPage(connectionProviderModel, connectionInfo, valueProvider, (Object)nextPage);
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        value = (Page)executionResult.getValue();
        items = value.getItems();
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(0), "3", "Three");
        ModelInterpreter001Test.assertProvidedValue((ProvidedValue)items.get(1), "4", "Four");
        nextPage = (Map)value.getNextPage().orElseThrow();
        this.assertNextPage(nextPage, 4, 2);
        executionResult = this.modelInterpreter.executeValueProviderNextPage(connectionProviderModel, connectionInfo, valueProvider, (Object)nextPage);
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        value = (Page)executionResult.getValue();
        MatcherAssert.assertThat((Object)value.getItems(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)value.getNextPage(), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    public void assertUser(TriggerItem triggerItem, int id, String name, String email, int created_at, int watermark, String identity, boolean base64) {
        Map item = (Map)triggerItem.getValue();
        ModelInterpreter001Test.assertUserItemValue(item, name, email, created_at, id);
        Serializable itemWatermark = triggerItem.getWatermark();
        MatcherAssert.assertThat((Object)(base64 ? this.deserializeObject(itemWatermark) : itemWatermark), (Matcher)CoreMatchers.equalTo((Object)watermark));
        MatcherAssert.assertThat((Object)triggerItem.getIdentity(), (Matcher)CoreMatchers.equalTo((Object)identity));
    }

    private static void assertUserItemValue(Map<?, ?> item, String name, String email, int created_at, int id) {
        MatcherAssert.assertThat((Object)item.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat(item.get("id"), (Matcher)CoreMatchers.equalTo((Object)id));
        MatcherAssert.assertThat(item.get("name"), (Matcher)CoreMatchers.equalTo((Object)name));
        MatcherAssert.assertThat(item.get("email"), (Matcher)CoreMatchers.equalTo((Object)email));
        MatcherAssert.assertThat(item.get("created_at"), (Matcher)CoreMatchers.equalTo((Object)created_at));
    }

    public static void assertAccount(Map<?, ?> value, String id, String name, String email) {
        MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(value.get("id"), (Matcher)CoreMatchers.equalTo((Object)id));
        MatcherAssert.assertThat(value.get("name"), (Matcher)CoreMatchers.equalTo((Object)name));
        MatcherAssert.assertThat(value.get("email"), (Matcher)CoreMatchers.equalTo((Object)email));
    }

    protected void assertNextPage(Map<?, ?> value, int offset, int limit) {
        MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Map args = (Map)value.get("args");
        MatcherAssert.assertThat((Object)args.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(args.get("offset"), (Matcher)CoreMatchers.equalTo((Object)offset));
        MatcherAssert.assertThat(args.get("limit"), (Matcher)CoreMatchers.equalTo((Object)limit));
    }

    private static void assertProvidedValue(ProvidedValue providedValue, String value, String label) {
        MatcherAssert.assertThat((Object)providedValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((Object)providedValue.getLabel(), (Matcher)CoreMatchers.is((Object)label));
    }

    private static Map<Object, Object> createPaginationParams(int offset, int limit) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        return params;
    }

    public static Map<Object, Object> createUpdateAccountParams(String value) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("accountId", value);
        HashMap<String, String> account = new HashMap<String, String>();
        account.put("name", "ACME");
        account.put("email", "support@acme.com");
        params.put("account", account);
        return params;
    }

    public @Nullable Object deserializeObject(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try (DataWeaveCall call = new DataWeaveCall(this.modelInterpreterConfig, dataWeaveEngine);){
            call.bind("object", object);
            Object object2 = call.when(() -> "deserializing").evalToJava("read(dw::core::Binaries::fromBase64(object) as Binary {encoding: \"UTF-8\"},'application/dw', { onlyData: true })");
            return object2;
        }
    }

    private /* synthetic */ void lambda$testConnection$0(2 otherConnectionClass) throws Throwable {
        this.modelInterpreter.testConnection((TestConnectionModel)null, (Connection)otherConnectionClass);
    }
}

