/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave;

import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class RegressionTests {
    @Test
    @DisplayName(value="W-15993545: toMuleType does not use structural equality")
    public void toMuleTypeDoesNotUseStructuralEquality() {
        String script = "%dw 2.8\ntype A = { x: Number, y: Number } <~ { format: \"type A\" }\ntype B = { x: Number, y: Number } <~ { format: \"type B\" }\nvar v: { a: A, b: B } = ???\n---\nv";
        DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();
        DWType wtype = (DWType)engine.inferTypeOf(script).get();
        ObjectType obj = (ObjectType)Assertions.assertInstanceOf(ObjectType.class, (Object)wtype);
        DWType typeA = DWTypeUtils.requireFieldByName((ObjectType)obj, (String)"a").getValue();
        DWType typeB = DWTypeUtils.requireFieldByName((ObjectType)obj, (String)"b").getValue();
        Assertions.assertNotSame((Object)typeA, (Object)typeB);
        TestUtils.assertFormat(obj, "a", "type A");
        TestUtils.assertFormat(obj, "b", "type B");
    }

    @Test
    @Disabled(value="Requires enabling reference types")
    @DisplayName(value="W-15993545: toMuleType allows different metadata on different references")
    public void toMuleTypeAllowsDifferentMetadataOnDifferentReferences() {
        String script = "%dw 2.8\ntype A = { x: Number, y: Number } <~ { format: \"type A\" }\ntype B = A <~ { format: \"type B\" }\ntype C = B <~ { format: \"type C\" }\nvar v: { a: A, b: B, c: C } = ???\n---\nv";
        DataWeaveScriptingEngine engine = new DataWeaveScriptingEngine();
        DWType wtype = (DWType)engine.inferTypeOf(script).get();
        ObjectType obj = (ObjectType)Assertions.assertInstanceOf(ObjectType.class, (Object)wtype);
        DWType typeA = DWTypeUtils.requireFieldByName((ObjectType)obj, (String)"a").getValue();
        DWType typeB = DWTypeUtils.requireFieldByName((ObjectType)obj, (String)"b").getValue();
        DWType typeC = DWTypeUtils.requireFieldByName((ObjectType)obj, (String)"c").getValue();
        Assertions.assertNotSame((Object)typeA, (Object)typeB);
        Assertions.assertNotSame((Object)typeB, (Object)typeC);
        Assertions.assertNotSame((Object)typeA, (Object)typeC);
        TestUtils.assertFormat(obj, "a", "type A");
        TestUtils.assertFormat(obj, "b", "type B");
        TestUtils.assertFormat(obj, "c", "type C");
    }
}

