/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import java.io.Serializable;
import java.util.Optional;
import org.mule.weave.v2.model.values.NullValue;

class LazyTriggerItem
implements TriggerItem {
    private final DataWeaveLiveValue liveValue;

    public LazyTriggerItem(DataWeaveLiveValue liveValue) {
        this.liveValue = liveValue;
        if (liveValue.getExecuteResult().getResult() instanceof NullValue) {
            throw new IllegalArgumentException("Can't build a trigger item from a null value");
        }
    }

    @Override
    public Object getValue() {
        return this.liveValue.evalToJava("result.value");
    }

    @Override
    public Optional<Content> getContent() {
        return Optional.of(new Content(this.liveValue.eval("result.value"), true));
    }

    @Override
    public Serializable getWatermark() {
        return (Serializable)this.liveValue.evalToJava("result.watermark");
    }

    @Override
    public String getIdentity() {
        return (String)this.liveValue.evalToJava("result.identity");
    }
}

