/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class ResultWeaveType {
    private final TypeModel successOperationExecutorReturnType;
    private final TypeModel failureOperationExecutor;
    private final List<TypeModel> failureOperationExecutorReturnType;

    public ResultWeaveType(DWType executorResult) {
        this.successOperationExecutorReturnType = ResultWeaveType.getOperationExecutorResultSuccess((UnionType)executorResult);
        this.failureOperationExecutor = ResultWeaveType.getOperationExecutorResultFailure((UnionType)executorResult);
        this.failureOperationExecutorReturnType = ResultWeaveType.getOperationExecutorResultFailureValues((UnionType)executorResult);
    }

    public TypeModel getSuccessOperationExecutorReturnType() {
        return this.successOperationExecutorReturnType;
    }

    public TypeModel errorOutputType() {
        return this.failureOperationExecutor;
    }

    public List<ErrorModel> getErrorModelList() {
        return this.failureOperationExecutorReturnType.stream().map(this::getErrorDefinitions).flatMap(Collection::stream).toList();
    }

    private List<ErrorModel> getErrorDefinitions(TypeModel errorDefinition) {
        DWType dWType = errorDefinition.getDataType();
        if (!(dWType instanceof IntersectionType)) {
            return List.of();
        }
        IntersectionType errorIntersection = (IntersectionType)dWType;
        DWType[] intersectionTypes = errorIntersection.intersectionOf();
        DWType errorValue = TypeUtils.getObjectProperty(intersectionTypes[0], "value").map(KeyValuePairType::getValue).orElseThrow(() -> new IllegalStateException("Cannot find property value in type: " + String.valueOf(intersectionTypes[0])));
        if (intersectionTypes.length > 2) {
            throw new IllegalStateException("Unexpected shape of error type: Expected a baseType & ErrorType intersection");
        }
        return this.getErrors(errorValue, WeaveTypeSimplifier.simplifyWeaveType(intersectionTypes[1]));
    }

    private List<ErrorModel> getErrors(DWType errorValue, DWType errorType) {
        if (!(errorType instanceof UnionType)) {
            return List.of(this.getError(errorValue, TypeUtils.resolveReferenceType(errorType)));
        }
        UnionType errorUnion = (UnionType)errorType;
        return Stream.of(errorUnion.unionOf()).map(TypeUtils::resolveReferenceType).map(value -> this.getError(errorValue, (DWType)value)).toList();
    }

    private ErrorModel getError(DWType errorValue, DWType errorType) {
        StringType kind = (StringType)TypeUtils.requireObjectPropertyType(errorType, "kind");
        ArrayType categoriesProperty = (ArrayType)TypeUtils.requireObjectPropertyType(errorType, "categories");
        DWType categories = TypeUtils.resolveReferenceType(categoriesProperty.arrayOf());
        TypeModel errorTypeModel = (TypeModel)new TypeModel.Builder().withDataType(errorValue).build();
        return new ErrorModel(kind.getValue().isEmpty() ? "" : (String)kind.getValue().get(), this.categories(categories), errorTypeModel);
    }

    private List<String> categories(DWType categories) {
        if (categories instanceof StringType) {
            StringType category = (StringType)categories;
            return category.getValue().stream().toList();
        }
        if (categories instanceof UnionType) {
            UnionType unionCategories = (UnionType)categories;
            return Arrays.stream(unionCategories.unionOf()).map(value -> (String)((StringType)value).getValue().orElseThrow()).toList();
        }
        throw new IllegalStateException("Unknown type for categories: " + String.valueOf(categories.getClass()));
    }

    private static TypeModel getOperationExecutorResultSuccess(UnionType unionType) {
        for (DWType innerType : unionType.unionOf()) {
            ObjectType of;
            boolean hasSuccessTrueProperty;
            DWType resolvedType = TypeUtils.resolveReferenceType(innerType);
            if (!(resolvedType instanceof ObjectType) || !(hasSuccessTrueProperty = Stream.of((of = (ObjectType)resolvedType).getProperties()).filter(keyValuePairType -> keyValuePairType.getKeyName().equals("success")).filter(keyValuePairType -> keyValuePairType.getValue() instanceof BooleanType).anyMatch(keyValuePairType -> Boolean.TRUE.equals(((BooleanType)keyValuePairType.getValue()).getValue().orElseThrow())))) continue;
            return (TypeModel)new TypeModel.Builder().withDataType(TypeUtils.getProperty(of, "value")).build();
        }
        throw new IllegalStateException("There should be a type {success: true} to describe the success type for the Operation executor. " + String.valueOf(unionType));
    }

    private static List<TypeModel> getOperationExecutorResultFailureValues(UnionType unionType) {
        for (DWType innerType : unionType.unionOf()) {
            ObjectType of;
            boolean hasSuccessFalseProperty;
            DWType resolvedType = TypeUtils.resolveReferenceType(innerType);
            if (resolvedType instanceof ObjectType && (hasSuccessFalseProperty = Stream.of((of = (ObjectType)resolvedType).getProperties()).filter(keyValuePairType -> keyValuePairType.getKeyName().equals("success")).filter(keyValuePairType -> keyValuePairType.getValue() instanceof BooleanType).anyMatch(keyValuePairType -> Boolean.FALSE.equals(((BooleanType)keyValuePairType.getValue()).getValue().orElseThrow())))) {
                return List.of((TypeModel)new TypeModel.Builder().withDataType(TypeUtils.getProperty(of, "error")).build());
            }
            if (!(resolvedType instanceof UnionType)) continue;
            UnionType u = (UnionType)resolvedType;
            return Stream.of(u.unionOf()).map(value -> (TypeModel)new TypeModel.Builder().withDataType(TypeUtils.getProperty((ObjectType)TypeUtils.resolveReferenceType(value), "error")).build()).toList();
        }
        throw new IllegalStateException("There should be a type {success: false} to describe the error type for the Operation executor. " + String.valueOf(unionType));
    }

    private static TypeModel getOperationExecutorResultFailure(UnionType unionType) {
        for (DWType innerType : unionType.unionOf()) {
            ObjectType of;
            boolean hasSuccessFalseProperty;
            DWType resolvedType = TypeUtils.resolveReferenceType(innerType);
            TypeModel.Builder typeModelBuilder = new TypeModel.Builder();
            if (resolvedType instanceof ObjectType && (hasSuccessFalseProperty = Stream.of((of = (ObjectType)resolvedType).getProperties()).filter(keyValuePairType -> keyValuePairType.getKeyName().equals("success")).filter(keyValuePairType -> keyValuePairType.getValue() instanceof BooleanType).anyMatch(keyValuePairType -> Boolean.FALSE.equals(((BooleanType)keyValuePairType.getValue()).getValue().orElseThrow())))) {
                return (TypeModel)typeModelBuilder.withDataType(innerType).build();
            }
            if (!(resolvedType instanceof UnionType)) continue;
            return (TypeModel)typeModelBuilder.withDataType(innerType).build();
        }
        throw new IllegalStateException("There should be a type {success: false} to describe the error type for the Operation executor. " + String.valueOf(unionType));
    }
}

