/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader.impl;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.loader.CanonicalConnectivityModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.LoaderUtils;
import com.mulesoft.connectivity.linkweave.api.loader.ReferencesAnnotationProcessor;
import com.mulesoft.connectivity.linkweave.api.loader.impl.ConnectionProviderLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.OperationLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.SourceOnlyWeaveResourceResolver;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TestConnectionLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TriggerLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.model.CanonicalConnectivityModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;

public class CanonicalConnectivityModelLoaderImpl
implements CanonicalConnectivityModelLoader {
    private static final NameIdentifier CONNECTION = NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::Metadata::ConnectionElement");
    private static final NameIdentifier TEST_CONNECTION = NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::Metadata::TestConnectionElement");
    private static final NameIdentifier OPERATION = NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::Metadata::OperationElement");
    private static final NameIdentifier TRIGGER = NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::Metadata::TriggerElement");

    @Override
    public CanonicalConnectivityModel load(@Nullable List<String> modules) {
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("modules cannot be null or empty");
        }
        ReferencesAnnotationProcessor operationReferencesAnnotationProcessor = new ReferencesAnnotationProcessor();
        ReferencesAnnotationProcessor connectionProviderReferencesAnnotationProcessor = new ReferencesAnnotationProcessor();
        ReferencesAnnotationProcessor testConnectionReferencesAnnotationProcessor = new ReferencesAnnotationProcessor();
        ReferencesAnnotationProcessor triggerReferencesAnnotationProcessor = new ReferencesAnnotationProcessor();
        ParserConfiguration parserConfiguration = new ParserConfigurationBuilder().addAnnotationProcessor(OPERATION, (DWAnnotationProcessor)operationReferencesAnnotationProcessor).addAnnotationProcessor(CONNECTION, (DWAnnotationProcessor)connectionProviderReferencesAnnotationProcessor).addAnnotationProcessor(TEST_CONNECTION, (DWAnnotationProcessor)testConnectionReferencesAnnotationProcessor).addAnnotationProcessor(TRIGGER, (DWAnnotationProcessor)triggerReferencesAnnotationProcessor).build();
        DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine(ModuleComponentsFactory.apply((WeaveResourceResolver)new SourceOnlyWeaveResourceResolver((WeaveResourceResolver)ClassLoaderWeaveResourceResolver.apply())), parserConfiguration);
        StringBuilder scriptBuilder = new StringBuilder();
        modules.forEach(module -> scriptBuilder.append("import * from ").append((String)module).append("\n"));
        scriptBuilder.append("---\ntrue");
        dataWeaveScriptingEngine.compile(scriptBuilder.toString());
        dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
        OperationLoaderImpl operationLoader = new OperationLoaderImpl();
        List<OperationModel> operations = this.getElementsModel(operationReferencesAnnotationProcessor.getReferences(), dataWeaveScriptingEngine, dor -> (OperationModel)operationLoader.loadModel(dor, null));
        TriggerLoaderImpl triggerLoader = new TriggerLoaderImpl();
        List<TriggerModel> triggers = this.getElementsModel(triggerReferencesAnnotationProcessor.getReferences(), dataWeaveScriptingEngine, dor -> (TriggerModel)triggerLoader.loadModel(dor, null));
        TestConnectionLoaderImpl testConnectionLoader = new TestConnectionLoaderImpl();
        List<TestConnectionModel> testConnections = this.getElementsModel(testConnectionReferencesAnnotationProcessor.getReferences(), dataWeaveScriptingEngine, dor -> (TestConnectionModel)testConnectionLoader.loadModel(dor, null));
        ConnectionProviderLoaderImpl connectionProviderLoader = new ConnectionProviderLoaderImpl(testConnectionLoader);
        List<ConnectionProviderModel> connectionProviders = this.getElementsModel(connectionProviderReferencesAnnotationProcessor.getReferences(), dataWeaveScriptingEngine, dor -> (ConnectionProviderModel)connectionProviderLoader.loadModel(dor, dor.getPath().replace("::", "-").replace(".", "-")));
        CanonicalConnectivityModel.CanonicalConnectivityModelBuilder builder = CanonicalConnectivityModel.builder();
        if (!testConnections.isEmpty()) {
            builder.testConnection(testConnections.get(0));
        }
        return builder.operations(operations).connectionProviders(connectionProviders).triggers(triggers).build();
    }

    private <T> List<T> getElementsModel(List<String> refs, DataWeaveScriptingEngine engine, Function<DataWeaveObjectReference, T> loader) {
        return refs.stream().map(ref -> new DataWeaveObjectReference((String)ref, (DWType)LoaderUtils.inferType(engine, ref), (Map)LoaderUtils.readValue(engine, ref))).map(loader).toList();
    }
}

