/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.ReferencesAnnotationProcessor;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DynamicModuleComponentFactory;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;

public class ReferenceAnnotationProcessorTest {
    private static final ReferencesAnnotationProcessor referencesAnnotationProcessor = new ReferencesAnnotationProcessor();

    @BeforeAll
    public static void init() {
        ParserConfiguration parserConfiguration = new ParserConfigurationBuilder().addAnnotationProcessor(NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::Metadata::OperationElement"), (DWAnnotationProcessor)referencesAnnotationProcessor).build();
        DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine((ModuleComponentsFactory)DynamicModuleComponentFactory.apply(), parserConfiguration);
        dataWeaveScriptingEngine.compile("import * from referenceProcessor::Module\n---\ntrue");
    }

    @Test
    public void obtainOperationReferences() {
        List operationReferences = referencesAnnotationProcessor.getReferences();
        HashSet references = new HashSet(operationReferences);
        MatcherAssert.assertThat((Object)operationReferences.size(), (Matcher)Matchers.equalTo((Object)5));
        Assertions.assertTrue((boolean)references.contains("referenceProcessor::Module::operations.operationValue"));
        Assertions.assertTrue((boolean)references.contains("referenceProcessor::Module::operations.operationRef"));
        Assertions.assertTrue((boolean)references.contains("referenceProcessor::Module::getAccountsPaginated"));
        Assertions.assertTrue((boolean)references.contains("referenceProcessor::Module::getAccounts"));
        Assertions.assertTrue((boolean)references.contains("referenceProcessor::Module::operationElement"));
    }
}

