/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.ResultWeaveType;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.FunctionType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;
import org.mule.weave.v2.api.tooling.ts.TypeSelectorType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.ts.ArrayMetadataValue;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.BooleanType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.NumberType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.SimpleReferenceType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.utils.StringEscapeHelper;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TypeUtils {
    private static final String FORMAT_KEY = "format";
    private static final String VALUES_KEY = "values";
    private static final org.mule.weave.v2.api.tooling.ts.ObjectType EMPTY_OBJECT = new ObjectType(TypeUtils.emptySeq(), false, false);
    private static final Map<String, Function<Map<?, ?>, DWType>> PRIMITIVE_TYPE_MAPPING = Map.of("String", map -> {
        List values = (List)map.get(VALUES_KEY);
        StringType stringType = new StringType(Option.empty());
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        TypeUtils.getFormat(map).ifPresent(metadatas::add);
        metadatas.addAll(TypeUtils.getEnumsMetadatas(values));
        for (Metadata metadata : metadatas) {
            stringType = stringType.withMetadata(metadata);
        }
        return stringType;
    }, "Number", map -> {
        List values = (List)map.get(VALUES_KEY);
        NumberType numberType = new NumberType(Option.empty());
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        TypeUtils.getFormat(map).ifPresent(metadatas::add);
        metadatas.addAll(TypeUtils.getEnumsMetadatas(values));
        for (Metadata metadata : metadatas) {
            numberType = numberType.withMetadata(metadata);
        }
        return numberType;
    }, "Boolean", map -> new BooleanType(Option.empty(), null), "Null", map -> new NullType());

    private static Optional<Metadata> getFormat(Map<?, ?> map) {
        return Optional.ofNullable((String)map.get(FORMAT_KEY)).map(format -> new LiteralMetadataValue(format, (WeaveType)new StringType(Option.empty()), null)).map(value -> new Metadata(MetadataKey.FORMAT.getKey(), (MetadataValue)value, null));
    }

    private static List<Metadata> getEnumsMetadatas(@Nullable List<?> values) {
        if (values == null) {
            return new ArrayList<Metadata>();
        }
        ArrayList<String> enumLabels = new ArrayList<String>();
        ArrayList<@Nullable V> enumValues = new ArrayList();
        for (Object o : values) {
            Map v = (Map)o;
            Object value2 = v.get("value");
            enumValues.add(value2);
            enumLabels.add(Objects.requireNonNullElseGet((String)v.get("label"), () -> Objects.toString(value2)));
        }
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        if (!enumValues.isEmpty()) {
            List<MetadataValue> valueList = enumValues.stream().map(value -> {
                if (value == null) {
                    return new LiteralMetadataValue("", (WeaveType)new NullType(), null);
                }
                return TypeUtils.createLiteralMetadataValue(value.toString(), value.getClass());
            }).map(MetadataValue.class::cast).toList();
            metadatas.add(new Metadata(MetadataKey.ENUM_VALUES.getKey(), (MetadataValue)TypeUtils.createArrayMetadataValue(valueList), null));
        }
        List<MetadataValue> labelMetadataValues = enumLabels.stream().map(labels -> new LiteralMetadataValue(labels, null, null)).map(MetadataValue.class::cast).toList();
        metadatas.add(new Metadata(MetadataKey.ENUM_LABELS.getKey(), (MetadataValue)TypeUtils.createArrayMetadataValue(labelMetadataValues), null));
        return metadatas;
    }

    private static ArrayMetadataValue createArrayMetadataValue(List<MetadataValue> valueList) {
        return new ArrayMetadataValue((Seq)JavaConverters.asScalaBuffer(valueList).seq(), null);
    }

    private static LiteralMetadataValue createLiteralMetadataValue(String value, Class<?> type) {
        return new LiteralMetadataValue(value, (WeaveType)(switch (type.getName()) {
            case "java.lang.Boolean" -> new BooleanType(Option.empty(), null);
            case "java.lang.Integer", "java.lang.Float", "java.lang.Double" -> new NumberType(Option.empty());
            case "java.lang.String" -> new StringType(Option.empty());
            default -> throw new RuntimeException("There is no handling for the class " + type.getName() + " when creating a LiteralMetadataValue");
        }), null);
    }

    private TypeUtils() {
    }

    public static FunctionType resolveFunctionType(DWType weaveType) {
        if (!((weaveType = TypeUtils.resolveReferenceType(weaveType)) instanceof FunctionType)) {
            throw new IllegalStateException("Inferred type should be a function type instead it is a " + weaveType.getClass().getName());
        }
        return (FunctionType)weaveType;
    }

    public static DWType resolveReferenceType(DWType weaveType) {
        if (weaveType instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)weaveType;
            return TypeUtils.resolveReferenceType(referenceType.resolveType());
        }
        return weaveType;
    }

    public static TypeModel inputType(FunctionType functionType) {
        return Stream.of(functionType.getParameters()).findFirst().map(functionTypeParameter -> (TypeModel)new TypeModel.Builder().withDataType(functionTypeParameter.getType()).build()).orElseThrow(() -> new IllegalStateException("Invalid function definition, there should be at least one input type parameter: " + String.valueOf(functionType.getLocation())));
    }

    public static @Nullable String weaveTypeToModelReference(DWType dataWeaveType) {
        if (dataWeaveType.getLocation() == null) {
            return null;
        }
        String resourceName = ((WeaveLocation)dataWeaveType.getLocation()).resourceName().name();
        if (NameIdentifier.ANONYMOUS_NAME().name().equals(resourceName)) {
            return null;
        }
        if (dataWeaveType instanceof SimpleReferenceType) {
            SimpleReferenceType referenceType = (SimpleReferenceType)dataWeaveType;
            return resourceName + "::" + String.valueOf(referenceType.refName());
        }
        if (dataWeaveType instanceof TypeSelectorType) {
            TypeSelectorType typeSelectorType = (TypeSelectorType)dataWeaveType;
            if (dataWeaveType instanceof org.mule.weave.v2.ts.TypeSelectorType) {
                org.mule.weave.v2.ts.TypeSelectorType wellKnownImplementation = (org.mule.weave.v2.ts.TypeSelectorType)dataWeaveType;
                Object field = wellKnownImplementation.refName();
                if (StringEscapeHelper.keyRequiresQuotes((String)field)) {
                    field = "\"" + (String)field + "\"";
                }
                return TypeUtils.weaveTypeToModelReference((DWType)wellKnownImplementation.referencedType()) + "." + (String)field;
            }
            resourceName = typeSelectorType.resolveType().getLocation().getResourceIdentifier().toString();
            String referenceTypeName = typeSelectorType.getReferenceTypeName();
            return resourceName + "::" + referenceTypeName;
        }
        return resourceName;
    }

    public static DWType requireObjectPropertyType(DWType weaveType, String propertyName) {
        return TypeUtils.getObjectPropertyType(weaveType, propertyName).orElseThrow(() -> new IllegalStateException("Cannot find property '" + propertyName + "' in type: " + String.valueOf(weaveType)));
    }

    public static Optional<DWType> getObjectPropertyType(DWType weaveType, String propertyName) {
        return TypeUtils.getObjectProperty(weaveType, propertyName).map(kv -> TypeUtils.resolveReferenceType(kv.getValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> getObjectProperty(DWType weaveType, String propertyName) {
        Optional<Object> optionalProperty;
        if (weaveType instanceof org.mule.weave.v2.api.tooling.ts.ObjectType) {
            org.mule.weave.v2.api.tooling.ts.ObjectType objectType = (org.mule.weave.v2.api.tooling.ts.ObjectType)weaveType;
            return Stream.of(objectType.getProperties()).filter(keyValuePairType -> {
                String keyName = keyValuePairType.getKeyName();
                return "_".equals(keyName) || keyName.equals(propertyName);
            }).findFirst();
        }
        if (weaveType instanceof ReferenceType) {
            DWType referenceType = TypeUtils.resolveReferenceType(weaveType);
            return TypeUtils.getObjectProperty(referenceType, propertyName);
        }
        if (weaveType instanceof IntersectionType) {
            IntersectionType objectType = (IntersectionType)weaveType;
            DWType[] referenceType = objectType.intersectionOf();
            int n = referenceType.length;
            int n2 = 0;
            while (n2 < n) {
                DWType intersectedType = referenceType[n2];
                optionalProperty = TypeUtils.getObjectProperty(intersectedType, propertyName);
                if (optionalProperty.isPresent()) {
                    return optionalProperty;
                }
                ++n2;
            }
            return Optional.empty();
        }
        if (!(weaveType instanceof UnionType)) throw new IllegalStateException("Invalid weave type: expected Object but " + String.valueOf(weaveType.getBaseType()) + " found");
        UnionType objectType = (UnionType)weaveType;
        ArrayList propertiesFound = new ArrayList();
        for (DWType intersectedType : objectType.unionOf()) {
            optionalProperty = TypeUtils.getObjectProperty(intersectedType, propertyName);
            optionalProperty.ifPresent(propertiesFound::add);
        }
        if (propertiesFound.isEmpty()) {
            return Optional.empty();
        }
        if (propertiesFound.size() == 1) {
            return Optional.of((org.mule.weave.v2.api.tooling.ts.KeyValuePairType)propertiesFound.get(0));
        }
        List<DWType> values = propertiesFound.stream().map(org.mule.weave.v2.api.tooling.ts.KeyValuePairType::getValue).toList();
        boolean optional = propertiesFound.stream().anyMatch(DWType::isOptional);
        boolean repeated = propertiesFound.stream().allMatch(org.mule.weave.v2.api.tooling.ts.KeyValuePairType::repeated);
        KeyType keyTypeT = new KeyType((WeaveType)new NameType(Option.apply((Object)new QName(propertyName, Option.empty()))), (Seq)JavaConverters.asScalaBuffer(new ArrayList()).seq());
        return Optional.of(new KeyValuePairType((WeaveType)keyTypeT, (WeaveType)TypeUtils.toUnionType(values), optional, repeated));
    }

    public static ResultWeaveType getOperationResult(DWType weaveType) {
        FunctionType functionType = TypeUtils.resolveFunctionType(weaveType);
        DWType returnType = TypeUtils.resolveReferenceType(functionType.getReturnType());
        if (!(returnType instanceof UnionType)) {
            throw new IllegalStateException("Operation.executor return type should be a union type, instead is a: " + String.valueOf(returnType));
        }
        UnionType unionType = (UnionType)returnType;
        return new ResultWeaveType((DWType)unionType);
    }

    public static DWType getProperty(org.mule.weave.v2.api.tooling.ts.ObjectType objectType, String propertyName) {
        return Stream.of(objectType.getProperties()).filter(keyValuePairType -> keyValuePairType.getKeyName().equals(propertyName)).map(org.mule.weave.v2.api.tooling.ts.KeyValuePairType::getValue).findFirst().orElseThrow(() -> new IllegalStateException("'" + propertyName + "' property not present in type:" + String.valueOf(objectType)));
    }

    public static org.mule.weave.v2.ts.UnionType toUnionType(List<DWType> weaveTypes) {
        return new org.mule.weave.v2.ts.UnionType((Seq)JavaConverters.asScalaBuffer(weaveTypes.stream().map(x -> (WeaveType)x).toList()).seq());
    }

    public static DWType resolveWeaveType(Function<String, DWType> translator, Map<?, ?> providerResult) {
        return TypeUtils.translate(translator, providerResult);
    }

    private static DWType translate(Function<String, DWType> translator, Map<?, ?> providerResult) {
        String typeName;
        switch (typeName = (String)Objects.requireNonNull(providerResult.get("type"), "providerResult has no type")) {
            case "Object": {
                List fields = (List)providerResult.get("fields");
                List<KeyValuePairType> properties = TypeUtils.asKeyValuePairTypes(translator, fields).stream().map(x -> (KeyValuePairType)x).toList();
                ObjectType objectTypeT = new ObjectType((Seq)JavaConverters.asScalaBuffer(properties).seq(), true, true);
                return objectTypeT.withMetadata(TypeUtils.createTypeIdMetadata(providerResult));
            }
            case "Array": {
                Map item = (Map)providerResult.get("item");
                return new ArrayType((WeaveType)TypeUtils.translate(translator, item)).withMetadata(TypeUtils.createTypeIdMetadata(providerResult));
            }
            case "Union": {
                List rawTypes = (List)providerResult.get("types");
                if (rawTypes.isEmpty()) {
                    throw new RuntimeException("Union needs at least one type");
                }
                Stream<DWType> types = rawTypes.stream().map(t -> TypeUtils.translate(translator, (Map)t));
                return new org.mule.weave.v2.ts.UnionType((Seq)JavaConverters.asScalaBuffer(types.map(x -> (WeaveType)x).toList()).seq());
            }
            case "ExtendedObject": {
                Object typeReference = providerResult.get("typeReference");
                org.mule.weave.v2.api.tooling.ts.ObjectType objectType = (org.mule.weave.v2.api.tooling.ts.ObjectType)translator.apply((String)typeReference);
                List customFields = (List)providerResult.get("customFields");
                ArrayList<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> properties = new ArrayList<org.mule.weave.v2.api.tooling.ts.KeyValuePairType>(TypeUtils.asKeyValuePairTypes(translator, customFields));
                Set propertyNames = properties.stream().map(org.mule.weave.v2.api.tooling.ts.KeyValuePairType::getKeyName).collect(Collectors.toSet());
                for (org.mule.weave.v2.api.tooling.ts.KeyValuePairType prop : objectType.getProperties()) {
                    if (propertyNames.contains(prop.getKeyName())) {
                        throw new RuntimeException(String.format("Field %s already exists", prop.getKeyName()));
                    }
                    properties.add(prop);
                }
                ObjectType objectTypeT = new ObjectType((Seq)JavaConverters.asScalaBuffer(properties.stream().map(x -> (KeyValuePairType)x).toList()).seq(), objectType.isClosed(), objectType.isOrdered());
                return objectTypeT.withMetadata(TypeUtils.createTypeIdMetadata(providerResult));
            }
        }
        if (PRIMITIVE_TYPE_MAPPING.containsKey(typeName)) {
            return PRIMITIVE_TYPE_MAPPING.get(typeName).apply(providerResult);
        }
        throw new RuntimeException(String.format("Cannot translate type : %s", typeName));
    }

    private static Metadata createTypeIdMetadata(Map<?, ?> providerResult) {
        return new Metadata(MetadataKey.TYPE_ID.getKey(), (MetadataValue)new LiteralMetadataValue((String)providerResult.get("name"), (WeaveType)new StringType(Option.empty()), null), null);
    }

    private static List<org.mule.weave.v2.api.tooling.ts.KeyValuePairType> asKeyValuePairTypes(Function<String, DWType> translator, List<?> fields) {
        return fields.stream().map(Map.class::cast).map(field -> {
            String key = (String)((Map)field.get("name")).get("localName");
            KeyType keyTypeT = new KeyType((WeaveType)new NameType(Option.apply((Object)new QName(key, Option.empty()))), (Seq)JavaConverters.asScalaBuffer(new ArrayList()).seq());
            KeyValuePairType result = new KeyValuePairType((WeaveType)keyTypeT, (WeaveType)TypeUtils.translate(translator, (Map)field.get("value")), (Boolean)field.get("required") == false, ((Boolean)field.get("repeated")).booleanValue());
            Map annotations = (Map)field.get("annotations");
            if (annotations != null) {
                annotations.forEach((name, value) -> result.withMetadata(new Metadata((String)name, TypeUtils.getMetadataValue(value), null)));
            }
            return result;
        }).toList();
    }

    private static MetadataValue getMetadataValue(Object value) {
        LiteralMetadataValue metadataValue;
        if (value instanceof List) {
            List<MetadataValue> valueList = ((List)value).stream().map(v -> {
                if (v == null) {
                    return new LiteralMetadataValue("", (WeaveType)new NullType(), null);
                }
                return TypeUtils.createLiteralMetadataValue(v.toString(), v.getClass());
            }).map(MetadataValue.class::cast).toList();
            metadataValue = TypeUtils.createArrayMetadataValue(valueList);
        } else {
            metadataValue = new LiteralMetadataValue((String)value, (WeaveType)new StringType(Option.empty()), null);
        }
        return metadataValue;
    }

    public static org.mule.weave.v2.api.tooling.ts.ObjectType emptyObject() {
        return EMPTY_OBJECT;
    }

    private static <T> Seq<T> emptySeq() {
        return JavaConverters.collectionAsScalaIterable(List.of()).toSeq();
    }
}

