/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class LazyResultError
implements ResultError {
    private static final long serialVersionUID = 1L;
    private final DataWeaveLiveValue liveValue;

    LazyResultError(DataWeaveLiveValue liveValue) {
        this.liveValue = liveValue;
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.liveValue.evalToNullableJava("result.error.description")).filter(String.class::isInstance).map(String.class::cast);
    }

    @Override
    public Object getValue() {
        return this.liveValue.evalToJava("result.error.value");
    }

    @Override
    public Optional<Content> asContent() {
        return Optional.of(new Content(this.liveValue.eval("result.error.value")));
    }

    @Override
    public String getKind() {
        return (String)this.liveValue.evalToJava("result.error.kind");
    }

    @Override
    public Set<String> getCategories() {
        return new HashSet<String>((Collection)this.liveValue.evalToJava("result.error.categories"));
    }

    @Override
    public Optional<Object> get(String property) {
        try (DataWeaveCall call = this.liveValue.call();){
            Object value = call.bind("prop", property).evalToNullableJava("result.error[prop]");
            Optional<Object> optional = Optional.ofNullable(value);
            return optional;
        }
    }

    @Override
    public Optional<ResultError> getCause() {
        if (!Boolean.TRUE.equals(this.liveValue.evalToNullableJava("result.error.cause?"))) {
            return Optional.empty();
        }
        return Optional.of(new LazyResultError(this.liveValue.eval("result update {\n    case .error -> result.error.cause update {\n        case .value! -> result.error.value\n    }\n}\n")));
    }

    @Override
    public ResultError asJsonSerializable() {
        Map additionalProperties = (Map)this.liveValue.evalToNullableJava("result.error -- ['description', 'value', 'kind', 'categories']");
        Object value = this.replaceStreams(this.getValue());
        return ResultError.error(this.getDescription().orElse(null), value, this.getKind(), this.getCategories(), additionalProperties);
    }

    private Object replaceStreams(Object o) {
        if (o instanceof Map) {
            Map m = (Map)o;
            return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.replaceStreams(e.getValue())));
        }
        if (o instanceof InputStream) {
            InputStream stream = (InputStream)o;
            try {
                return stream.readAllBytes();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return o;
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.asJsonSerializable();
    }
}

