/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.ReaderWriterConfig;
import java.util.HashMap;
import java.util.Map;
import org.mule.weave.v2.model.ServiceManager;
import scala.Predef;
import scala.collection.JavaConverters;

public class ModelInterpreterConfig {
    private final ReaderWriterConfig readerConfig;
    private final ReaderWriterConfig writerConfig;
    private final ServiceManager serviceManager;
    private final Map<Object, Object> cache;
    private final boolean base64EncodeTriggerState;

    private ModelInterpreterConfig(ReaderWriterConfig readerConfig, ReaderWriterConfig writerConfig, Map<Class<?>, Object> services, Map<Object, Object> cache, boolean base64EncodeTriggerState) {
        this.readerConfig = readerConfig;
        this.writerConfig = writerConfig;
        this.serviceManager = ServiceManager.apply((scala.collection.immutable.Map)((scala.collection.mutable.Map)JavaConverters.mapAsScalaMapConverter(services).asScala()).toMap(Predef.conforms()));
        this.cache = cache;
        this.base64EncodeTriggerState = base64EncodeTriggerState;
    }

    public ReaderWriterConfig getReaderConfig() {
        return this.readerConfig;
    }

    public ReaderWriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public boolean shouldBase64EncodeTriggerState() {
        return this.base64EncodeTriggerState;
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    public static class Builder {
        private ReaderWriterConfig readerConfig = new ReaderWriterConfig("application/java", new HashMap<String, Object>());
        private ReaderWriterConfig writerConfig = new ReaderWriterConfig("application/java", new HashMap<String, Object>());
        private final Map<Class<?>, Object> services = new HashMap();
        private Map<Object, Object> cache = new HashMap<Object, Object>();
        private boolean base64EncodeTriggerState;

        public Builder readerConfig(ReaderWriterConfig config) {
            this.readerConfig = config;
            return this;
        }

        public Builder writerConfig(ReaderWriterConfig config) {
            this.writerConfig = config;
            return this;
        }

        @Deprecated
        public Builder operationExecutionModule(String moduleName) {
            return this;
        }

        public Builder triggerExecutionModule(String moduleName) {
            return this;
        }

        public Builder valueProviderExecutionModule(String moduleName) {
            return this;
        }

        public Builder addService(Class<?> serviceClass, Object serviceInstance) {
            this.services.put(serviceClass, serviceInstance);
            return this;
        }

        public Builder cache(Map<Object, Object> cache) {
            this.cache = cache;
            return this;
        }

        public Builder base64EncodeTriggerState(boolean base64EncodeTriggerState) {
            this.base64EncodeTriggerState = base64EncodeTriggerState;
            return this;
        }

        public ModelInterpreterConfig build() {
            return new ModelInterpreterConfig(this.readerConfig, this.writerConfig, this.services, this.cache, this.base64EncodeTriggerState);
        }
    }
}

