/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection.oauth;

import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OAuth2AuthCodeAuthenticationType
extends OAuth2AuthenticationType {
    private final String authorizationUrl;
    private final String tokenUrl;

    public OAuth2AuthCodeAuthenticationType(OAuth2AuthenticationType.Placement placement, @Nullable String refreshUrl, List<String> scopes, String authorizationUrl, String tokenUrl) {
        super(OAuth2AuthenticationType.GrantType.authorizationCode, placement, refreshUrl, scopes);
        this.authorizationUrl = Objects.requireNonNull(authorizationUrl, "'authorizationUrl' cannot be null");
        this.tokenUrl = Objects.requireNonNull(tokenUrl, "'tokenUrl' cannot be null");
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public String toString() {
        return "OAuth2AuthenticationType{  subType='" + String.valueOf(this.getSubType()) + "', authorizationUrl='" + this.authorizationUrl + "', tokenUrl='" + this.tokenUrl + "', refreshUrl='" + this.getRefreshUrl() + "', scopes=" + String.valueOf(this.getScopes()) + "}";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2AuthCodeAuthenticationType that = (OAuth2AuthCodeAuthenticationType)o;
        return Objects.equals(this.authorizationUrl, that.authorizationUrl) && Objects.equals(this.tokenUrl, that.tokenUrl) && Objects.equals(this.getRefreshUrl(), that.getRefreshUrl()) && Objects.equals(this.getScopes(), that.getScopes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authorizationUrl, this.tokenUrl, this.getRefreshUrl(), this.getScopes());
    }
}

