/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection.oauth;

import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationTypeVisitor;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ImplicitAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2PasswordAuthenticationType;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class OAuth2AuthenticationType
extends HttpAuthenticationType {
    private final Placement placement;
    private final @Nullable String refreshUrl;
    private final List<String> scopes;

    public OAuth2AuthenticationType(GrantType grantType, Placement placement, @Nullable String refreshUrl, List<String> scopes) {
        super(HttpAuthenticationType.Type.oauth2, String.valueOf((Object)grantType));
        this.placement = placement;
        this.refreshUrl = refreshUrl;
        this.scopes = scopes;
    }

    public @Nullable String getRefreshUrl() {
        return this.refreshUrl;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public static OAuth2AuthenticationType create(Map<?, ?> attributes) {
        GrantType grantType = GrantType.fromString((String)attributes.get("grantType"));
        String refreshUrl = (String)attributes.get("refreshUrl");
        List scopes = (List)attributes.get("scopes");
        String authorizationUrl = (String)attributes.get("authorizationUrl");
        String tokenUrl = (String)attributes.get("tokenUrl");
        Placement placement = Placement.fromString((String)attributes.get("placement"));
        return switch (grantType) {
            default -> throw new IncompatibleClassChangeError();
            case GrantType.authorizationCode -> new OAuth2AuthCodeAuthenticationType(placement, refreshUrl, scopes, authorizationUrl, tokenUrl);
            case GrantType.clientCredentials -> new OAuth2ClientCredentialsAuthenticationType(placement, refreshUrl, scopes, tokenUrl);
            case GrantType.implicit -> new OAuth2ImplicitAuthenticationType(placement, refreshUrl, scopes, authorizationUrl);
            case GrantType.password -> new OAuth2PasswordAuthenticationType(placement, refreshUrl, scopes, tokenUrl);
        };
    }

    @Override
    public void accept(AuthenticationTypeVisitor authenticationTypeVisitor) {
        authenticationTypeVisitor.visitOAuth2HttpAuthenticationType(this);
    }

    public static enum Placement {
        body,
        basicAuth;


        public static Placement fromString(String value) {
            return body.name().equals(value) ? body : basicAuth;
        }
    }

    public static enum GrantType {
        authorizationCode,
        clientCredentials,
        implicit,
        password;


        public static GrantType fromString(String value) {
            return switch (value) {
                case "authorizationCode" -> authorizationCode;
                case "clientCredentials" -> clientCredentials;
                case "implicit" -> implicit;
                case "password" -> password;
                default -> throw new IllegalArgumentException("Unsupported GrantType: " + value);
            };
        }
    }
}

