/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.internal.dataweave;

import com.mulesoft.connectivity.linkweave.internal.dataweave.Converters;
import com.mulesoft.connectivity.linkweave.internal.dataweave.Expression;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.ArrayDataWeaveValue;
import org.mule.weave.v2.runtime.DataWeaveValue;

public abstract class ArrayItemExpression
extends Expression {
    protected final Expression left;
    protected final Expression subindex;

    protected ArrayItemExpression(Expression left, Expression subindex) {
        this.left = left;
        this.subindex = subindex;
    }

    @Override
    public @Nullable DataWeaveValue evaluate(Function<String, @Nullable DataWeaveValue> bindings) {
        DataWeaveValue dataWeaveValue = this.left.evaluate(bindings);
        if (!(dataWeaveValue instanceof ArrayDataWeaveValue)) {
            throw new IllegalArgumentException("Not an array, it's " + ArrayItemExpression.describe(dataWeaveValue));
        }
        ArrayDataWeaveValue array = (ArrayDataWeaveValue)dataWeaveValue;
        int i = ((Number)Objects.requireNonNull(Converters.toJava(this.subindex.evaluate(bindings)), "subindex must not be null")).intValue();
        DataWeaveValue[] elements = array.elements();
        if (i < 0) {
            i += elements.length;
        }
        return this.evaluate(elements, i);
    }

    protected abstract DataWeaveValue evaluate(DataWeaveValue[] var1, int var2);
}

