/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class DataWeaveLiveValueTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    DataWeaveLiveValueTest() {
    }

    @Test
    public void selectBoolean() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            call.bind("aBoolean", (Object)true);
            try (DataWeaveLiveValue liveValue = call.eval("{x: aBoolean}");){
                MatcherAssert.assertThat((Object)liveValue.selectBoolean("x"), (Matcher)Matchers.is(Optional.of(true)));
            }
        }
    }

    @Test
    public void notAnObject() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            call.bind("aBoolean", (Object)true);
            try (DataWeaveLiveValue liveValue = call.eval("aBoolean");){
                Assertions.assertThrows(IllegalStateException.class, () -> liveValue.selectBoolean("x"));
            }
        }
    }
}

