/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModelLoaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class StreamingTest {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<TestConnectorModel, TestConnectorModel.Builder> modelLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new TestConnectorModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    private @Nullable DataWeaveCall lastCall;
    private final ModelInterpreter modelInterpreter = new ModelInterpreter(this.dataWeaveEngine, new ModelInterpreterConfig.Builder().build()){

        DataWeaveCall call() {
            StreamingTest.this.lastCall = super.call();
            return StreamingTest.this.lastCall;
        }
    };

    @Test
    void streamedRawResult() throws IOException, NoSuchFieldException, IllegalAccessException {
        TestConnectorModel connector = (TestConnectorModel)this.modelLoader.loadModule("streaming::Connector");
        OperationModel operation = connector.getOperation("getData");
        ConnectionProviderModel c = connector.getConnectionProviders().get(0);
        try (Content res = (Content)this.modelInterpreter.executeOperation((Connection)Connection.of((BaseConnectionProviderModel)c, Map.of()), (BaseExecutableComponentModel)operation, Map.of()).getValue();){
            MatcherAssert.assertThat((Object)((String)res.rawContentType().orElseThrow()), (Matcher)Matchers.startsWith((String)"application/json"));
            try (InputStream inputStream = (InputStream)res.raw().orElseThrow();){
                byte[] bytes = inputStream.readAllBytes();
                try (InputStream expectedStream = Objects.requireNonNull(this.getClass().getResourceAsStream("/streaming/some-data.json"));){
                    byte[] expectedBytes = expectedStream.readAllBytes();
                    MatcherAssert.assertThat((Object)bytes, (Matcher)Matchers.equalTo((Object)expectedBytes));
                }
            }
        }
        Field usageCountField = DataWeaveCall.class.getDeclaredField("usageCount");
        usageCountField.setAccessible(true);
        MatcherAssert.assertThat((Object)usageCountField.getInt(this.lastCall), (Matcher)Matchers.is((Object)-1));
    }
}

