%dw 2.8

import Int32 from com::mulesoft::connectivity::Types
import Description from com::mulesoft::connectivity::decorator::Annotations

type AnnouncementBannerConfigurationUpdate = {
  isDismissible?: @Description(value = "Flag indicating if the announcement banner can be dismissed by the user.") Boolean,
  isEnabled?: @Description(value = "Flag indicating if the announcement banner is enabled or not.") Boolean,
  message?: @Description(value = "The text on the announcement banner.") String,
  visibility?: @Description(value = "Visibility of the announcement banner. Can be public or private.") String
}

type AnnouncementBannerConfiguration = {
  hashId?: @Description(value = "Hash of the banner data. The client detects updates by comparing hash IDs.") String,
  isDismissible?: @Description(value = "Flag indicating if the announcement banner can be dismissed by the user.") Boolean,
  isEnabled?: @Description(value = "Flag indicating if the announcement banner is enabled or not.") Boolean,
  message?: @Description(value = "The text on the announcement banner.") String,
  visibility?: @Description(value = "Visibility of the announcement banner.") "PUBLIC" | "PRIVATE"
}

type ErrorCollection = {
  errorMessages?: @Description(value = "The list of error messages produced by this operation. For example, \"input parameter 'key' must be provided\"") Array<String>,
  errors?: @Description(value = "The list of errors by parameter returned by the operation. For example,\"projectKey\": \"Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters.\"") {
    _?: String
  },
  status?: Int32
}
