%dw 2.8

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::decorator::Trigger
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::Types

type Project = {
   id: String,
   name: String,
}

var getProjects : Operation<{}, HttpResponse<{items: Array<Project>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getProjects",
    displayName: "Get Projects",
    executor: (parameter, connection) -> success({
          contentType: "application/json",
          status: 200,
          headers: {},
          cookies: {},
          body: {
            items: [
              {
                id: "1",
                name: "Project One",
              },
              {
                id: "2",
                name: "Project Two",
              },
              {
                id: "3",
                name: "Project Three",
              },
              {
                id: "4",
                name: "Project Four",
              },
            ]
          }
    })
}

var projectsValueProvider =
    defineValueProvider(getProjects.executor, (response: HttpResponse<{items: Array<Project>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name}}))

// Ticket Type

type TicketType = {
   id: String,
   name: String
}

var getProjectTicketTypes : Operation<{id: String}, HttpResponse<{items: Array<TicketType>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getProjectTicketTypes",
    displayName: "Get Project Tocket Types",
    executor: (parameter, connection) -> parameter.id match {
        case "1" -> do {
          success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {},
                body: {
                  items: [
                    {
                      id: "1",
                      name: "Project One Bug",
                    },
                    {
                      id: "2",
                      name: "Project One Feature",
                    },
                    {
                      id: "3",
                      name: "Project One Investigation",
                    },
                  ]
                }
          })
          }
        case "2" -> do {
           success({
                 contentType: "application/json",
                 status: 200,
                 headers: {},
                 cookies: {},
                 body: {
                   items: [
                     {
                       id: "1",
                       name: "Project Two Bug",
                     },
                     {
                       id: "2",
                       name: "Project Two Feature",
                     },
                     {
                       id: "3",
                       name: "Project Two Investigation",
                     },
                   ]
                 }
           })
           }
           else -> do {
                   success({
                         contentType: "application/json",
                         status: 200,
                         headers: {},
                         cookies: {},
                         body: {
                           items: []
                         }
                   })
            }
    }
}

var ticketTypesValueProvider =
    defineValueProvider(getProjectTicketTypes.executor, (response: HttpResponse<{items: Array<TicketType>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name}}))

// Ticket
type CreateTicketType = {
    projectId: @Description(value = "The project where the ticket is created") @ValuesFrom(value = { name: "projectsValueProvider" }) String,
    ticketType: @Description(value = "The type of the ticket to create") @ValuesFrom(value = { name: "ticketTypesValueProvider", arguments: { id: "projectId" } }) String,
    description: String,
    ticketDate: LWDate,
    createdAt: LWDateTime,
    amount: Integer,
    size: Float,
    price: Double,
    count: Int32,
    total: Int64
}

type Ticket = {
    id: String,
    projectId: String,
    ticketType: String,
    description: String,
    ticketDate: LWDate,
    createdAt: LWDateTime,
    amount: Integer,
    size: Float,
    price: Double,
    count: Int32,
    total: Int64
}

// Connection

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var simpleConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"}
)

@ConnectionElement()
var bearerConnection = defineBearerHttpConnectionProvider<BearerAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"}
)

@ConnectionElement()
var apiKeyConnection = defineApiKeyHttpConnectionProvider<ApiKeyAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"},
    {in: 'header', name: "X-API-KEY"}
)

@ConnectionElement()
var oauth2AuthCodeConnectionProvider = defineOAuth2Connection<OAuth2AuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"},
    {
        grantType: 'authorizationCode',
        authorizationUrl: "http://localhost/authorize",
        tokenUrl: "http://localhost/token",
        refreshUrl: "http://localhost/token",
        scopes: ["test"]
    }
)

@ConnectionElement()
var connection = defineBasicHttpConnectionProvider<@Label(value = "Twilio basic connection") {
    baseUri: @Label(value = "The base uri that will be used for all HTTP requests") String,
    user: @Label(value = "The username used to authenticate the requests") String,
    pass: @Label(value = "The password used to authenticate the requests") @SemanticTerms(value = ["password"]) String
}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

var createTicket : Operation<CreateTicketType, HttpResponse<Ticket>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "createTicket",
    displayName: "Create Ticket",
    executor: (parameter, connection): Result<HttpResponse<Ticket>, ResultFailure<HttpResponse, Error>> ->
        success({
            contentType: "application/json",
            status: 200,
            headers: connection.headers default {} ++ { baseUri: connection.baseUri default "" },
            cookies: {},
            body: {id: "1"} ++ parameter
    }) as ResultSuccess<HttpResponse<Ticket>>
}

type GetUsersRequest = {
    since: LWDate,
    project?: @Description(value = "The project where the ticket is created") @ValuesFrom(value = { name: "projectsValueProvider" }) String
}
type GetUsersResponse = {items: Array<User>}
type User = {id: String, name: String, email: String, created_at: LWDate}

var getUsers : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        success({
                          contentType: "application/json",
                          status: 200,
                          headers: {},
                          cookies: {},
                          body: {
                            items: [
                              {
                                  id: 1,
                                  name: "pepe",
                                  email: "p@sales.com",
                                  created_at: "20200102"
                              },
                              {
                                  id: 2,
                                  name: "pepito",
                                  email: "pe@sales.com",
                                  created_at: "20200105"
                              }
                            ]
                        }
                 } as HttpResponse<GetUsersResponse>)
    }
}

var myTriggerStrategy:TriggerStrategy<HttpResponse<GetUsersResponse>,User,User,String> =
{
    items: (result) -> result.body.items,
    item: (item) -> item,
    watermark: (result,item) -> item.created_at,
    identity: (item) -> item.id as String,
    watermarkCompareTo: DefaultWatermarkComparison
}

@TriggerElement()
var getUsersTrigger: Trigger<GetUsersRequest, GetUsersRequest, HttpResponse<GetUsersResponse>, GetUsersRequest, ResultFailure<HttpResponse, Error>, HttpConnection, User, User, String> = {
    name: "getUsersTrigger",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsers,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (triggerInput, connection) -> "20200101"
}

@TestConnector()
var connector = {
    name: "DataWeaveExtension",
    displayName: "Data Weave Extension",
    connections: {basicAuth: connection, simpleAuth: simpleConnection, bearer: bearerConnection,
                    apiKey: apiKeyConnection, oauth2: oauth2AuthCodeConnectionProvider},
    operations: {
       createTicket: createTicket
    },
    testConnection: testConnection,
    metadataProviders: {},
    valueProviders: {
        projectsValueProvider: projectsValueProvider,
        ticketTypesValueProvider: ticketTypesValueProvider,
    },
    triggers: {getUsersTrigger: getUsersTrigger}
}
