/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.interpreter.Result;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.model.structure.schema.Schema;
import scala.Option;

public class Content
implements Result {
    private final DataWeaveLiveValue liveValue;
    private final boolean serialize;

    Content(DataWeaveLiveValue liveValue) {
        this(liveValue, false);
    }

    Content(DataWeaveLiveValue liveValue, boolean serialize) {
        this.liveValue = liveValue;
        this.serialize = serialize;
    }

    public @Nullable Object get() {
        return this.liveValue.evalToNullableJava("result");
    }

    public Optional<InputStream> raw() {
        String rawScript = this.serialize ? "write(result, result.^mimeType default 'application/json') as Binary" : "result.^raw";
        return Optional.ofNullable(this.liveValue.evalToNullableJava(rawScript)).filter(InputStream.class::isInstance).map(InputStream.class::cast);
    }

    public Optional<String> rawContentType() {
        return (Optional)this.getResultMetadata().flatMap(s -> s.mimeType(null)).map(Optional::of).getOrElse(() -> this.serialize ? Optional.of("application/json") : Optional.empty());
    }

    public Optional<Map<String, Object>> getTransportAttributes() {
        return Optional.ofNullable(this.liveValue.evalToNullableJava("result.^transportAttributes")).filter(Map.class::isInstance).map(Map.class::cast);
    }

    @Override
    public void close() {
        this.liveValue.close();
    }

    @Override
    public boolean isPage() {
        return false;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    public Page<Object> asPage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content asContent() {
        return this;
    }

    private Option<Schema> getResultMetadata() {
        return this.liveValue.getExecuteResult().getResultMaterialized().schema(null);
    }
}

