/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ConnectorExecutionException;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.internal.dataweave.Expression;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.core.exception.ExecutionException;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.runtime.BindingValue;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

class DataWeaveCall
implements AutoCloseable {
    private final ScriptingBindings bindings;
    private final Set<String> boundNames = new HashSet<String>();
    private final Map<String, ExecuteResult> boundExecuteResults;
    private final Map<String, String> replacements;
    private final ModelInterpreterConfig config;
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private boolean frozen = false;
    private int usageCount = 0;
    private @Nullable Supplier<String> when;
    private static final ScriptingBindings EMPTY_BINDINGS = ScriptingBindings.apply();

    DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine) {
        this(config, dataWeaveEngine, ScriptingBindings.apply(), new HashMap<String, ExecuteResult>(), new HashMap<String, String>());
    }

    private DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine, ScriptingBindings bindings, Map<String, ExecuteResult> boundExecuteResults, Map<String, String> replacements) {
        this.config = Objects.requireNonNull(config);
        this.dataWeaveEngine = Objects.requireNonNull(dataWeaveEngine);
        this.bindings = bindings;
        this.boundExecuteResults = boundExecuteResults;
        this.boundNames.addAll(Arrays.asList(bindings.bindingNames()));
        this.replacements = replacements;
    }

    DataWeaveCall bind(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "Name cannot be null");
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot bind a value to a frozen call");
        }
        if (value instanceof ExecuteResult) {
            ExecuteResult executeResult = (ExecuteResult)value;
            this.checkDuplicateBinding(name);
            this.boundExecuteResults.put(name, executeResult);
            this.bindings.addBinding(name, executeResult.getResultMaterialized());
        } else {
            if (value instanceof Model) {
                Model model = (Model)value;
                this.replacements.put(name, ModelInterpreter.getModelReference(model));
                return this;
            }
            if (value instanceof Connection) {
                Connection connection = (Connection)value;
                this.replacements.put(name, ModelInterpreter.getModelReference(connection.getProvider()) + ".connect(connectionInfo)");
                return this.bind("connectionInfo", connection.getInfo());
            }
            this.checkDuplicateBinding(name);
            this.bindings.addBinding(name, BindingValue.apply((Object)value, (String)"application/java"));
        }
        return this;
    }

    private static ScriptingBindings cloneBindings(ScriptingBindings bindings) {
        ScriptingBindings newBindings = ScriptingBindings.apply();
        bindings.bindings().foreach(t -> newBindings.addBinding((String)t._1, (BindingValue)t._2));
        bindings.literalValues().foreach(t -> newBindings.addBinding((String)t._1, (Value)t._2));
        return newBindings;
    }

    private void checkDuplicateBinding(String name) {
        if (!this.boundNames.add(name)) {
            throw new IllegalStateException("Duplicate binding: " + name);
        }
    }

    public DataWeaveLiveValue eval(String scriptText) {
        ExecuteResult result = this.doExecute(this.compile(this.applyReplacements(scriptText)), this.bindings);
        DataWeaveLiveValue liveValue = new DataWeaveLiveValue(result, this.config, this.dataWeaveEngine);
        liveValue.registerCloseable(this);
        ++this.usageCount;
        return liveValue;
    }

    protected void registerCloseable(AutoCloseable dataWeaveCall) {
        this.closeables.add(dataWeaveCall);
    }

    private ExecuteResult doExecute(DataWeaveScript script, ScriptingBindings bindings) {
        try {
            return script.exec(bindings, this.config.getServiceManager());
        }
        catch (Exception e) {
            ExecutionException executionException;
            block5: {
                block4: {
                    this.logViaDWService(e);
                    if (!(e instanceof ExecutionException)) break block4;
                    executionException = (ExecutionException)e;
                    if (this.when != null) break block5;
                }
                throw e;
            }
            throw new ConnectorExecutionException("Connector failed when " + this.when.get() + ": " + executionException.message(), executionException);
        }
    }

    @Nullable Object evalToNullableJava(String scriptText) {
        if (Expression.supported(scriptText) && this.replacements.isEmpty()) {
            Expression compiled = (Expression)this.config.getCache().computeIfAbsent(List.of("fastpath!", scriptText), k -> Expression.compile(scriptText));
            return compiled.toJava(this.bindings, this.boundExecuteResults);
        }
        DataWeaveScript script = this.compile(this.applyReplacements(scriptText));
        try {
            return script.write(this.bindings, this.config.getServiceManager(), "application/java").getContent();
        }
        catch (Exception e) {
            ExecutionException executionException;
            block7: {
                block6: {
                    this.logViaDWService(e);
                    if (!(e instanceof ExecutionException)) break block6;
                    executionException = (ExecutionException)e;
                    if (this.when != null) break block7;
                }
                throw e;
            }
            throw new ConnectorExecutionException("Connector failed when " + this.when.get() + ": " + executionException.message(), executionException);
        }
    }

    private String applyReplacements(String scriptText) {
        String actualScript = scriptText;
        for (Map.Entry<String, String> e : this.replacements.entrySet()) {
            actualScript = actualScript.replaceAll("(?<!::|\\.)\\b" + Pattern.quote(e.getKey()) + "\\b", e.getValue());
        }
        return actualScript;
    }

    Object evalToJava(String scriptText) {
        return Objects.requireNonNull(this.evalToNullableJava(scriptText), () -> "Evaluation of '" + scriptText + "' returned null");
    }

    public DataWeaveCall newCall() {
        return new DataWeaveCall(this.config, this.dataWeaveEngine, DataWeaveCall.cloneBindings(this.bindings), new HashMap<String, ExecuteResult>(this.boundExecuteResults), new HashMap<String, String>(this.replacements));
    }

    public DataWeaveCall when(Supplier<String> when) {
        this.when = when;
        return this;
    }

    private DataWeaveScript compile(String scriptText) {
        return this.compile(scriptText, this.bindings.bindingNames());
    }

    private DataWeaveScript compile(String scriptText, String[] names) {
        return (DataWeaveScript)this.config.getCache().computeIfAbsent(List.of(scriptText, Arrays.asList(names)), k -> {
            try {
                return this.dataWeaveEngine.compile(scriptText, names);
            }
            catch (Exception e) {
                this.logViaDWService(e);
                throw e;
            }
        });
    }

    private void logViaDWService(Exception e) {
        this.dataWeaveEngine.loggingService().exists(service -> {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            service.logError(String.format("Dataweave execution failed: %s", sw));
            return null;
        });
    }

    protected void freeze() {
        this.frozen = true;
    }

    protected boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public synchronized void close() {
        if (this.usageCount-- > 0) {
            return;
        }
        Exception primaryException = null;
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (primaryException == null) {
                    primaryException = e;
                    continue;
                }
                primaryException.addSuppressed(e);
            }
        }
        if (primaryException != null) {
            throw new IllegalStateException("Exception while closing DataWeaveCall", primaryException);
        }
    }
}

