/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.runtime.ScriptingBindings;

class DataWeaveObjectReferenceTest
extends AbstractConnectivityModelTest {
    private final String script = "%dw 2.7\nvar contact = {name: \"John\", age: 25, address: {city: \"New York\"}, tall: true, nothing: null}";
    private final DWType type = (DWType)dataWeaveScriptingEngine.inferTypeOf("%dw 2.7\nvar contact = {name: \"John\", age: 25, address: {city: \"New York\"}, tall: true, nothing: null}\n---\ncontact").get();
    private final Map<?, ?> value = (Map)dataWeaveScriptingEngine.compile("%dw 2.7\nvar contact = {name: \"John\", age: 25, address: {city: \"New York\"}, tall: true, nothing: null}\n---\ncontact").write(ScriptingBindings.apply(), ServiceManager.apply(), "application/java").getContent();

    DataWeaveObjectReferenceTest() {
    }

    @Test
    void constructorAndGetters() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        MatcherAssert.assertThat((Object)o.getPath(), (Matcher)Matchers.is((Object)"contact"));
        MatcherAssert.assertThat((Object)((Map)o.getValue()), (Matcher)Matchers.hasKey((Object)"name"));
        MatcherAssert.assertThat((Object)o.getType(), (Matcher)Matchers.instanceOf(ObjectType.class));
    }

    @Test
    void getProperty() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        DataWeaveReference contact = (DataWeaveReference)o.getProperty("name").orElseThrow();
        MatcherAssert.assertThat((Object)contact.getPath(), (Matcher)Matchers.is((Object)"contact.name"));
        MatcherAssert.assertThat((Object)contact.getValue(), (Matcher)Matchers.is((Object)"John"));
    }

    @Test
    void requireProperty() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        DataWeaveReference contact = o.requireProperty("name");
        MatcherAssert.assertThat((Object)contact.getPath(), (Matcher)Matchers.is((Object)"contact.name"));
        MatcherAssert.assertThat((Object)contact.getValue(), (Matcher)Matchers.is((Object)"John"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> o.requireProperty("non-existent-property"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"A required property 'non-existent-property' is missing."));
    }

    @Test
    void getObjectProperty() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        DataWeaveObjectReference address = (DataWeaveObjectReference)o.getObjectProperty("address").orElseThrow();
        MatcherAssert.assertThat((Object)((Map)address.getValue()), (Matcher)Matchers.hasEntry((Object)"city", (Object)"New York"));
        MatcherAssert.assertThat((Object)address.getPath(), (Matcher)Matchers.is((Object)"contact.address"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> o.getObjectProperty("age"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"The property 'age' was expected to be an object, but it's a NumberType instead."));
    }

    @Test
    void requireObjectProperty() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        DataWeaveObjectReference address = o.requireObjectProperty("address");
        MatcherAssert.assertThat((Object)((Map)address.getValue()), (Matcher)Matchers.hasEntry((Object)"city", (Object)"New York"));
        MatcherAssert.assertThat((Object)address.getPath(), (Matcher)Matchers.is((Object)"contact.address"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> o.requireObjectProperty("non-existent-property"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"A required property 'non-existent-property' is missing."));
    }

    @Test
    void casts() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        DataWeaveReference name = (DataWeaveReference)o.getProperty("name").orElseThrow();
        MatcherAssert.assertThat((Object)name.asString(), (Matcher)Matchers.is((Object)"John"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> ((DataWeaveReference)name).asBoolean());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Expected 'contact.name' to be a boolean, but it's '\"John\"'"));
        DataWeaveReference tall = (DataWeaveReference)o.getProperty("tall").orElseThrow();
        MatcherAssert.assertThat((Object)tall.asBoolean(), (Matcher)Matchers.is((Object)true));
        ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> ((DataWeaveReference)tall).asString());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Expected 'contact.tall' to be a string, but it's 'true'"));
    }

    @Test
    void properties() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        List<Map.Entry<String, ? extends DataWeaveReference<?>>> l = o.properties().toList();
        DataWeaveObjectReferenceTest.assertEntryList(l);
    }

    @Test
    void forEachProperty() {
        DataWeaveObjectReference o = new DataWeaveObjectReference("contact", this.type, this.value);
        ArrayList l = new ArrayList();
        o.forEachProperty((name, value) -> l.add(Map.entry(name, value)));
        DataWeaveObjectReferenceTest.assertEntryList(l);
    }

    private static void assertEntryList(List<Map.Entry<String, ? extends DataWeaveReference<?>>> l) {
        MatcherAssert.assertThat(l, (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)l.get(0).getKey(), (Matcher)Matchers.is((Object)"name"));
        MatcherAssert.assertThat(l.get(0).getValue(), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)"John")));
        MatcherAssert.assertThat((Object)l.get(1).getKey(), (Matcher)Matchers.is((Object)"age"));
        MatcherAssert.assertThat(l.get(1).getValue(), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)25)));
        MatcherAssert.assertThat((Object)l.get(2).getKey(), (Matcher)Matchers.is((Object)"address"));
        MatcherAssert.assertThat(l.get(2).getValue(), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.hasEntry((Object)"city", (Object)"New York")));
        MatcherAssert.assertThat((Object)l.get(3).getKey(), (Matcher)Matchers.is((Object)"tall"));
        MatcherAssert.assertThat(l.get(3).getValue(), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.is((Object)true)));
    }
}

