/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.internal.dataweave;

import com.mulesoft.connectivity.linkweave.internal.dataweave.ArrayGetItemExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.Converters;
import com.mulesoft.connectivity.linkweave.internal.dataweave.Expression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.FieldSelectionExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.ItemExistsInArrayExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.SizeOfArrayExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.VariableExpression;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jspecify.annotations.NullMarked;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.runtime.SimpleDataWeaveValue;

@NullMarked
class ExpressionTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    ExpressionTest() {
    }

    @Test
    void testSupported_SimpleVariable() {
        MatcherAssert.assertThat((Object)Expression.supported((String)"varName"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"myVar"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var123"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testSupported_FieldSelection() {
        MatcherAssert.assertThat((Object)Expression.supported((String)"obj.field"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"obj.field1.field2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"a.b.c.d"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testSupported_ArrayAccess() {
        MatcherAssert.assertThat((Object)Expression.supported((String)"arr[i]"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"obj.field[i]"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testSupported_ArrayExistenceCheck() {
        MatcherAssert.assertThat((Object)Expression.supported((String)"arr[i]?"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"obj.field[i]?"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testSupported_SizeOf() {
        MatcherAssert.assertThat((Object)Expression.supported((String)"sizeOf(arr)"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"sizeOf(obj.field)"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)Expression.supported((String)"sizeOf(obj.field[i])"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testSupported_InvalidExpressions() {
        MatcherAssert.assertThat((Object)Expression.supported((String)""), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"123var"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var-name"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var.name.field."), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var[]"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var[0][1]"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var.field()"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Expression.supported((String)"var + 1"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testCompile_SimpleVariable() {
        Expression expr = Expression.compile((String)"myVar");
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(VariableExpression.class)));
    }

    @Test
    void testCompile_FieldSelection() {
        Expression expr = Expression.compile((String)"obj.field");
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(FieldSelectionExpression.class)));
    }

    @Test
    void testCompile_ArrayAccess() {
        Expression expr = Expression.compile((String)"arr[0]");
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ArrayGetItemExpression.class)));
    }

    @Test
    void testCompile_ArrayExistenceCheck() {
        Expression expr = Expression.compile((String)"arr[0]?");
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ItemExistsInArrayExpression.class)));
    }

    @Test
    void testCompile_SizeOf() {
        Expression expr = Expression.compile((String)"sizeOf(arr)");
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(SizeOfArrayExpression.class)));
    }

    @Test
    void testEvaluate_SimpleVariable() {
        Expression expr = Expression.compile((String)"myNumber");
        SimpleDataWeaveValue value = Converters.toDataWeaveValue((Number)42);
        DataWeaveValue result = expr.evaluate(arg_0 -> ExpressionTest.lambda$testEvaluate_SimpleVariable$0((DataWeaveValue)value, arg_0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)value));
    }

    @Test
    void testEvaluate_FieldSelection() {
        Expression expr = Expression.compile((String)"person.name");
        DataWeaveValue person = this.evalDW("{name: \"John\", age: 30}");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("person".equals(name)) {
                return person;
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)"John"));
    }

    @Test
    void testEvaluate_NestedFieldSelection() {
        Expression expr = Expression.compile((String)"person.address.city");
        DataWeaveValue person = this.evalDW("{name: \"John\", address: {city: \"New York\", zip: \"10001\"}}");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("person".equals(name)) {
                return person;
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)"New York"));
    }

    @Test
    void testEvaluate_ArrayAccess() {
        Expression expr = Expression.compile((String)"items[i]");
        DataWeaveValue items = this.evalDW("[10, 20, 30]");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)0);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)10));
    }

    @Test
    void testEvaluate_ArrayAccessWithVariableIndex() {
        Expression expr = Expression.compile((String)"items[i]");
        DataWeaveValue items = this.evalDW("[10, 20, 30]");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)1);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)20));
    }

    @Test
    void testEvaluate_ArrayAccessWithNegativeIndex() {
        Expression expr = Expression.compile((String)"items[i]");
        DataWeaveValue items = this.evalDW("[10, 20, 30]");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)-1);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)30));
    }

    @Test
    void testEvaluate_ArrayExistenceCheck_Exists() {
        Expression expr = Expression.compile((String)"items[i]?");
        DataWeaveValue items = this.evalDW("[10, 20]");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)0);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testEvaluate_ArrayExistenceCheck_NotExists() {
        Expression expr = Expression.compile((String)"items[i]?");
        DataWeaveValue items = this.evalDW("[10, 20]");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)5);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testEvaluate_SizeOf() {
        Expression expr = Expression.compile((String)"sizeOf(items)");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("items".equals(name)) {
                return this.evalDW("[10, 20, 30]");
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)3));
    }

    @Test
    void testEvaluate_ComplexExpression() {
        Expression expr = Expression.compile((String)"person.addresses[i].city");
        DataWeaveValue person = this.evalDW("{name: \"John\", addresses: [{city: \"New York\", zip: \"10001\"}, {city: \"Boston\", zip: \"02101\"}]}");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("person".equals(name)) {
                return person;
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)0);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        Object javaValue = Converters.toJava((DataWeaveValue)result);
        MatcherAssert.assertThat((Object)javaValue, (Matcher)Matchers.is((Object)"New York"));
    }

    @Test
    void testEvaluate_FieldSelectionOnNonObject() {
        Expression expr = Expression.compile((String)"number.field");
        Assertions.assertThrows(IllegalArgumentException.class, () -> expr.evaluate(name -> {
            if ("number".equals(name)) {
                return Converters.toDataWeaveValue((Number)42);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        }));
    }

    @Test
    void testEvaluate_ArrayAccessOnNonArray() {
        Expression expr = Expression.compile((String)"number[i]");
        Assertions.assertThrows(IllegalArgumentException.class, () -> expr.evaluate(name -> {
            if ("number".equals(name)) {
                return Converters.toDataWeaveValue((Number)42);
            }
            if ("i".equals(name)) {
                return Converters.toDataWeaveValue((Number)0);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        }));
    }

    @Test
    void testEvaluate_SizeOfOnNonArray() {
        Expression expr = Expression.compile((String)"sizeOf(number)");
        Assertions.assertThrows(IllegalArgumentException.class, () -> expr.evaluate(name -> {
            if ("number".equals(name)) {
                return Converters.toDataWeaveValue((Number)42);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        }));
    }

    @Test
    void testToJava_SimpleVariable() {
        Expression expr = Expression.compile((String)"myNumber");
        SimpleDataWeaveValue value = Converters.toDataWeaveValue((Number)42);
        Object result = expr.toJava(arg_0 -> ExpressionTest.lambda$testToJava_SimpleVariable$16((DataWeaveValue)value, arg_0));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)42));
    }

    @Test
    void testToJava_FieldSelection() {
        Expression expr = Expression.compile((String)"person.age");
        DataWeaveValue person = this.evalDW("{name: \"John\", age: 30}");
        Object result = expr.toJava(name -> {
            if ("person".equals(name)) {
                return person;
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)30));
    }

    @Test
    void testToJava_ArrayAccess() {
        Expression expr = Expression.compile((String)"items[1]");
        DataWeaveValue items = this.evalDW("[10, 20, 30]");
        Object result = expr.toJava(name -> {
            if ("items".equals(name)) {
                return items;
            }
            if ("1".equals(name) || "i".equals(name)) {
                return Converters.toDataWeaveValue((Number)1);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)20));
    }

    @Test
    void testToJava_WithScriptingBindings() {
        Expression expr = Expression.compile((String)"myNumber");
        ScriptingBindings bindings = ScriptingBindings.apply();
        HashMap boundExecuteResults = new HashMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> expr.toJava(bindings, boundExecuteResults));
    }

    @Test
    void testEvaluate_NullVariable() {
        Expression expr = Expression.compile((String)"null");
        DataWeaveValue result = expr.evaluate(name -> {
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    void testEvaluate_MissingField() {
        Expression expr = Expression.compile((String)"person.missingField");
        DataWeaveValue person = this.evalDW("{name: \"John\"}");
        DataWeaveValue result = expr.evaluate(name -> {
            if ("person".equals(name)) {
                return person;
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        });
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void describe() {
        MatcherAssert.assertThat((Object)Expression.describe((DataWeaveValue)this.evalDW("1")), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)Expression.describe((DataWeaveValue)this.evalDW("null")), (Matcher)Matchers.is((Object)"null"));
        MatcherAssert.assertThat((Object)Expression.describe(null), (Matcher)Matchers.is((Object)"<null>"));
        MatcherAssert.assertThat((Object)Expression.describe((DataWeaveValue)this.evalDW("{}")), (Matcher)Matchers.startsWith((String)"org.mule.weave.v2.runtime.ObjectDataWeaveValue@"));
    }

    private DataWeaveValue evalDW(String script) {
        try (ExecuteResult result = dataWeaveEngine.compile(script).exec(ScriptingBindings.apply(), ServiceManager.apply());){
            DataWeaveValue dataWeaveValue = result.asDWValue();
            return dataWeaveValue;
        }
    }

    private static /* synthetic */ DataWeaveValue lambda$testToJava_SimpleVariable$16(DataWeaveValue value, String name) {
        if ("myNumber".equals(name)) {
            return value;
        }
        throw new IllegalArgumentException("Unknown variable: " + name);
    }

    private static /* synthetic */ DataWeaveValue lambda$testEvaluate_SimpleVariable$0(DataWeaveValue value, String name) {
        if ("myNumber".equals(name)) {
            return value;
        }
        throw new IllegalArgumentException("Unknown variable: " + name);
    }
}

