/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class ContentTest {
    private final ModelInterpreterConfig modelInterpreterConfig = new ModelInterpreterConfig.Builder().build();
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    ContentTest() {
    }

    @Test
    void get() {
        try (Content c = this.contentFor("1", false);){
            MatcherAssert.assertThat((Object)c.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    void raw() throws IOException {
        InputStream s;
        try (Content c = this.contentFor("1", false);){
            MatcherAssert.assertThat((Object)c.raw(), (Matcher)Matchers.is(Optional.empty()));
            MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)Matchers.is(Optional.empty()));
        }
        c = this.contentFor("{messages: [\"Hello\", \"Good bye\"]} <~ {raw: \"!raw!\" as Binary}\n", false);
        try {
            s = (InputStream)c.raw().orElseThrow();
            try {
                MatcherAssert.assertThat((Object)new String(s.readAllBytes(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"!raw!"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)Matchers.is(Optional.empty()));
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        c = this.contentFor("{messages: [\"Hello\", \"Good bye\"]} <~ {raw: \"\" as Binary {base: \"64\"}}\n", true);
        try {
            s = (InputStream)c.raw().orElseThrow();
            try {
                MatcherAssert.assertThat((Object)new String(s.readAllBytes(), StandardCharsets.UTF_8), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"{\n  \"messages\": [\n    \"Hello\",\n    \"Good bye\"\n  ]\n}"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)Matchers.is(Optional.of("application/json")));
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        c = this.contentFor("{messages: [\"Hello\", \"Good bye\"]} <~ {mimeType: \"application/json; charset=utf-8\", raw: \"!raw!\" as Binary}\n", false);
        try {
            s = (InputStream)c.raw().orElseThrow();
            try {
                MatcherAssert.assertThat((Object)new String(s.readAllBytes(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"!raw!"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)Matchers.is(Optional.of("application/json; charset=utf-8")));
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        c = this.contentFor("{messages: [\"Hello\", \"Good bye\"]} <~ {mimeType: null, raw: \"!raw!\" as Binary}\n", false);
        try {
            s = (InputStream)c.raw().orElseThrow();
            try {
                MatcherAssert.assertThat((Object)new String(s.readAllBytes(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"!raw!"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            MatcherAssert.assertThat((Object)c.rawContentType(), (Matcher)Matchers.is(Optional.empty()));
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    private Content contentFor(String scriptText, boolean serialize) {
        try (DataWeaveCall call = new DataWeaveCall(this.modelInterpreterConfig, this.dataWeaveEngine);){
            Content content = new Content(call.eval(scriptText), serialize);
            return content;
        }
    }
}

