/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModelLoaderFactory;
import com.mulesoft.connectivity.linkweave.test.OptionalMatchers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class TestConnectionTestCase {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private static final LanguageModelLoader<TestConnectorModel, TestConnectorModel.Builder> modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new TestConnectorModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    protected final ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveEngine, new ModelInterpreterConfig.Builder().build());
    private static final TestConnectorModel VALID_CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("testConnection::ValidConnector");
    private static final TestConnectorModel VALID_HTTP_TEST_CONNECTION_CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("testConnection::ValidHttpTestConnectionConnector");
    private static final TestConnectorModel INVALID_CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("testConnection::InvalidConnector");
    private static final TestConnectorModel FAILING_TEST_CONNECTION_CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("testConnection::FailingTestConnectionConnector");
    private static final Map<String, Object> connectionInfo = TestConnectionTestCase.createConnectionInfo();

    private static Map<String, Object> createConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://api.acme.com/v1");
        connectionInfo.put("user", "jdoe");
        connectionInfo.put("pass", "secret");
        return connectionInfo;
    }

    @Test
    void globalTestConnection() {
        TestConnectionModel testConnectionModel = VALID_CONNECTOR_MODEL.getTestConnection();
        ConnectionProviderModel connectionProviderModel = VALID_CONNECTOR_MODEL.getConnectionProviders().get(0);
        assert (testConnectionModel != null);
        ConnectionValidationResult result = this.modelInterpreter.testConnection(testConnectionModel, (BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        OperationResult opRes = this.modelInterpreter.toOperationResult(result);
        MatcherAssert.assertThat((Object)opRes.isSuccess(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void globalHttpTestConnection() {
        TestConnectionModel testConnectionModel = VALID_HTTP_TEST_CONNECTION_CONNECTOR_MODEL.getTestConnection();
        ConnectionProviderModel connectionProviderModel = VALID_HTTP_TEST_CONNECTION_CONNECTOR_MODEL.getConnectionProviders().get(0);
        Assertions.assertNotNull((Object)testConnectionModel);
        ConnectionValidationResult result = this.modelInterpreter.testConnection(testConnectionModel, (BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assertions.assertTrue((boolean)result.getErrorMessage().isEmpty());
        Assertions.assertTrue((boolean)result.getErrorDetails().isEmpty());
    }

    @Test
    void connectionProvidersTestConnection() {
        List<ConnectionProviderModel> connectionProviders = VALID_CONNECTOR_MODEL.getConnectionProviders();
        MatcherAssert.assertThat(connectionProviders, (Matcher)Matchers.hasSize((int)2));
        ConnectionProviderModel connectionProviderModel = connectionProviders.get(0);
        ConnectionValidationResult result = this.modelInterpreter.testConnection((BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        connectionProviderModel = connectionProviders.get(1);
        result = this.modelInterpreter.testConnection((BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void invalidConnectorSetupForTestConnection() {
        TestConnectionModel testConnectionModel = INVALID_CONNECTOR_MODEL.getTestConnection();
        MatcherAssert.assertThat((Object)testConnectionModel, (Matcher)CoreMatchers.nullValue());
        List<ConnectionProviderModel> connectionProviders = INVALID_CONNECTOR_MODEL.getConnectionProviders();
        MatcherAssert.assertThat(connectionProviders, (Matcher)Matchers.hasSize((int)2));
        ConnectionProviderModel connectionProviderModel = INVALID_CONNECTOR_MODEL.getConnectionProviders().get(0);
        TestConnectionModel testConnection = connectionProviderModel.getTestConnection();
        MatcherAssert.assertThat((Object)testConnection, (Matcher)CoreMatchers.nullValue());
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.modelInterpreter.testConnection((BaseConnectionProviderModel)connectionProviderModel, connectionInfo));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"No 'validate' function found in testConnection::InvalidConnector::connector.connections.basicAuth to run a test connection"));
    }

    @Test
    void failingTestConnection() {
        TestConnectionModel testConnectionModel = FAILING_TEST_CONNECTION_CONNECTOR_MODEL.getTestConnection();
        ConnectionProviderModel connectionProviderModel = FAILING_TEST_CONNECTION_CONNECTOR_MODEL.getConnectionProviders().get(0);
        assert (testConnectionModel != null);
        ConnectionValidationResult result = this.modelInterpreter.testConnection(testConnectionModel, (BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.getErrorMessage(), OptionalMatchers.isPresentAnd(CoreMatchers.equalTo((Object)"M")));
        MatcherAssert.assertThat((Object)result.getErrorDetails(), OptionalMatchers.isPresentAnd(CoreMatchers.equalTo((Object)"D")));
        OperationResult opRes = this.modelInterpreter.toOperationResult(result);
        MatcherAssert.assertThat((Object)opRes.isSuccess(), (Matcher)CoreMatchers.equalTo((Object)false));
        ResultError errorValue = opRes.getErrorValue();
        MatcherAssert.assertThat((Object)errorValue.getKind(), (Matcher)CoreMatchers.is((Object)"connection-validation-error"));
        MatcherAssert.assertThat((Object)errorValue.getValue(), (Matcher)CoreMatchers.is((Object)"M"));
        MatcherAssert.assertThat((Object)((String)errorValue.getDescription().orElseThrow()), (Matcher)CoreMatchers.is((Object)"D"));
    }
}

