%dw 2.8

import ConnectionElement from com::mulesoft::connectivity::Metadata

import BasicAuthSchema, OAuth2AuthSchema, defineBasicHttpConnectionProvider, defineOAuth2Connection from com::mulesoft::connectivity::transport::Http

@ConnectionElement()
var basicAuth = defineBasicHttpConnectionProvider<BasicAuthSchema & { baseUri: String }>((schema) -> {
  username: schema.username,
  password: schema.password
}, (schema) -> {
  baseUri: schema.baseUri
})

@ConnectionElement()
var OAuth2 = defineOAuth2Connection<OAuth2AuthSchema & { baseUri: String }>((schema) -> {
  accessToken: schema.accessToken
}, (schema) -> {
  baseUri: schema.baseUri
}, {
  grantType: "authorizationCode",
  authorizationUrl: "https://auth.atlassian.com/authorize",
  tokenUrl: "https://auth.atlassian.com/oauth/token",
  scopes: ["delete:async-task:jira", "delete:attachment:jira", "delete:avatar:jira", "delete:comment.property:jira", "delete:comment:jira", "delete:dashboard.property:jira", "delete:dashboard:jira", "delete:field-configuration-scheme:jira", "delete:field-configuration:jira", "delete:field.option:jira", "delete:field:jira", "delete:filter.column:jira", "delete:filter:jira", "delete:group:jira", "delete:issue-link-type:jira", "delete:issue-link:jira", "delete:issue-type-scheme:jira", "delete:issue-type-screen-scheme:jira", "delete:issue-type.property:jira", "delete:issue-type:jira", "delete:issue-worklog.property:jira", "delete:issue-worklog:jira", "delete:issue.property:jira", "delete:issue.remote-link:jira", "delete:issue:jira", "delete:permission-scheme:jira", "delete:permission:jira", "delete:project-category:jira", "delete:project-role:jira", "delete:project-version:jira", "delete:project.avatar:jira", "delete:project.component:jira", "delete:project.property:jira", "delete:project:jira", "delete:screen-scheme:jira", "delete:screen-tab:jira", "delete:screen:jira", "delete:screenable-field:jira", "delete:user-configuration:jira", "delete:user.property:jira", "delete:webhook:jira", "delete:workflow-scheme:jira", "delete:workflow.property:jira", "delete:workflow:jira", "manage:jira-configuration", "manage:jira-project", "manage:jira-webhook", "read:application-role:jira", "read:attachment:jira", "read:audit-log:jira", "read:avatar:jira", "read:comment.property:jira", "read:comment:jira", "read:custom-field-contextual-configuration:jira", "read:dashboard.property:jira", "read:dashboard:jira", "read:field-configuration-scheme:jira", "read:field-configuration:jira", "read:field.default-value:jira", "read:field.option:jira", "read:field.options:jira", "read:field:jira", "read:filter.column:jira", "read:filter.default-share-scope:jira", "read:filter:jira", "read:group:jira", "read:instance-configuration:jira", "read:issue-details:jira", "read:issue-event:jira", "read:issue-field-values:jira", "read:issue-link-type:jira", "read:issue-link:jira", "read:issue-meta:jira", "read:issue-security-level:jira", "read:issue-security-scheme:jira", "read:issue-status:jira", "read:issue-type-hierarchy:jira", "read:issue-type-scheme:jira", "read:issue-type-screen-scheme:jira", "read:issue-type.property:jira", "read:issue-type:jira", "read:issue-worklog.property:jira", "read:issue-worklog:jira", "read:issue.changelog:jira", "read:issue.property:jira", "read:issue.remote-link:jira", "read:issue.time-tracking:jira", "read:issue.transition:jira", "read:issue.vote:jira", "read:issue.votes:jira", "read:issue.watcher:jira", "read:issue:jira", "read:jira-expressions:jira", "read:jira-user", "read:jira-work", "read:jql:jira", "read:label:jira", "read:license:jira", "read:notification-scheme:jira", "read:permission-scheme:jira", "read:permission:jira", "read:priority:jira", "read:project-category:jira", "read:project-role:jira", "read:project-type:jira", "read:project-version:jira", "read:project.avatar:jira", "read:project.component:jira", "read:project.email:jira", "read:project.feature:jira", "read:project.property:jira", "read:project:jira", "read:resolution:jira", "read:role:jira", "read:screen-field:jira", "read:screen-scheme:jira", "read:screen-tab:jira", "read:screen:jira", "read:screenable-field:jira", "read:status:jira", "read:user-configuration:jira", "read:user.columns:jira", "read:user.property:jira", "read:user:jira", "read:webhook:jira", "read:workflow-scheme:jira", "read:workflow.property:jira", "read:workflow:jira", "send:notification:jira", "validate:jql:jira", "write:attachment:jira", "write:avatar:jira", "write:comment.property:jira", "write:comment:jira", "write:custom-field-contextual-configuration:jira", "write:dashboard.property:jira", "write:dashboard:jira", "write:field-configuration-scheme:jira", "write:field-configuration:jira", "write:field.default-value:jira", "write:field.option:jira", "write:field:jira", "write:filter.column:jira", "write:filter.default-share-scope:jira", "write:filter:jira", "write:group:jira", "write:instance-configuration:jira", "write:issue-link-type:jira", "write:issue-link:jira", "write:issue-type-scheme:jira", "write:issue-type-screen-scheme:jira", "write:issue-type.property:jira", "write:issue-type:jira", "write:issue-worklog.property:jira", "write:issue-worklog:jira", "write:issue.property:jira", "write:issue.remote-link:jira", "write:issue.time-tracking:jira", "write:issue.vote:jira", "write:issue.watcher:jira", "write:issue:jira", "write:jira-work", "write:permission-scheme:jira", "write:permission:jira", "write:project-category:jira", "write:project-role:jira", "write:project-version:jira", "write:project.avatar:jira", "write:project.component:jira", "write:project.email:jira", "write:project.feature:jira", "write:project.property:jira", "write:project:jira", "write:screen-scheme:jira", "write:screen-tab:jira", "write:screen:jira", "write:screenable-field:jira", "write:user-configuration:jira", "write:user.property:jira", "write:webhook:jira", "write:workflow-scheme:jira", "write:workflow.property:jira", "write:workflow:jira"]
})
