%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Types
import * from com::mulesoft::connectivity::decorator::Trigger

type LeftNegativeInvalid = Error<"LEFT", "INVALID_PARAMETER">

var leftInstance : LeftNegativeInvalid = {
    kind: "LEFT",
    categories : ["INVALID_PARAMETER"]
}

type RightNegativeInvalid = Error<"RIGHT", "INVALID_PARAMETER">

var rightInstance : RightNegativeInvalid = {
    kind: "RIGHT",
    categories: ["INVALID_PARAMETER"]
}

type UnknownError = Error<"UNKNOWN", "">

var unknownInstance: UnknownError = {
    kind: "UNKNOWN",
    categories: []
}

var errorValueWithMultipleErrorTypes : Operation<{left: Number, right: Number}, Number, ResultFailure<Number, LeftNegativeInvalid | RightNegativeInvalid>, Null> = {
    name: "errorValueWithMultipleErrorTypes",
    displayName: "Sum two values, left + right",
    executor: (parameter, context) -> if (parameter.left > 0 and parameter.right > 0 and parameter.right < 3)
                                         success(parameter.left + parameter.right)
                                      else
                                        failure(1, leftInstance, "")
}

var errorValueWithOneErrorType : Operation<{left: Number, right: Number}, Number, ResultFailure<Number, LeftNegativeInvalid>, Null> = {
    name: "errorValueWithOneErrorType",
    displayName: "Sum two values, left + right",
    executor: (parameter, context) -> if (parameter.left > 0 and parameter.right > 0 and parameter.right < 3)
                                         success(parameter.left + parameter.right)
                                      else
                                        failure(1, leftInstance, "")
}

var multipleErrorValuesWithMultipleErrorTypes : Operation<{left: Number, right: Number}, Number, ResultFailure<Number, LeftNegativeInvalid| RightNegativeInvalid> | ResultFailure<String, UnknownError>, Null> = {
    name: "multipleErrorValuesWithMultipleErrorTypes",
    displayName: "Sum two values, left + right",
    executor: (parameter, context) -> if (parameter.left > 0 and parameter.right > 0 and parameter.right < 3)
                                         success(parameter.left + parameter.right)
                                      else if (parameter.left < 0)
                                         failure(-1, leftInstance, "")
                                      else if (parameter.right < 0)
                                        failure(-1, rightInstance, "")
                                      else
                                        failure("1", unknownInstance, "")
}

type GetUsersRequest = {since: LWDate, project?: String <~ {valueProvider: {name: "projectsValueProvider"}, description: "The project where the ticket is created"} }
type GetUsersResponse = {items: Array<User>}
type User = {id: String, name: String, email: String, created_at: LWDate}

var response : HttpResponse<GetUsersResponse> =
    {
        contentType: "application/json",
        status: 200,
        headers: {},
        cookies: {},
        body: {
            items: [
                {
                    id: "1",
                    name: "pepe",
                    email: "p@sales.com",
                    created_at: "20200102"
                },
                {
                    id: "2",
                    name: "pepito",
                    email: "pe@sales.com",
                    created_at: "20200105"
                }
            ]
        }
   }

var getUsersMultipleErrorTypes : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<Number, LeftNegativeInvalid | RightNegativeInvalid>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        success(response)
    }
}

var getUsersOneErrorType : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<Number, LeftNegativeInvalid>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        success(response)
    }
}

var getUsersMultipleValuesMultipleErrorType : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<Number, LeftNegativeInvalid| RightNegativeInvalid> | ResultFailure<String, UnknownError>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        success(response)
    }
}

var myTriggerStrategy:TriggerStrategy<HttpResponse<GetUsersResponse>, User, User, String> =
{
    items: (result) -> result.body.items,
    item: (item) -> item,
    watermark: (result,item) -> item.created_at,
    identity: (item) -> item.id as String,
    watermarkCompareTo: DefaultWatermarkComparison
}

var getUsersTriggerMultipleErrorTypes: Trigger<GetUsersRequest, GetUsersRequest, HttpResponse<GetUsersResponse>, GetUsersRequest, ResultFailure<Number, LeftNegativeInvalid | RightNegativeInvalid>, HttpConnection, User, User, String> = {
    name: "getUsersTriggerMultipleErrorTypes",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsersMultipleErrorTypes,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (triggerInput, connection) -> "1"
}

var getUsersTriggerOneErrorTypes: Trigger<GetUsersRequest, GetUsersRequest, HttpResponse<GetUsersResponse>, GetUsersRequest, ResultFailure<Number, LeftNegativeInvalid>, HttpConnection, User, User, String> = {
    name: "getUsersTriggerOneErrorTypes",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsersOneErrorType,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (triggerInput, connection) -> "1"
}

var getUsersTriggerMultipleValuesMultipleErrorTypes: Trigger<GetUsersRequest, GetUsersRequest, HttpResponse<GetUsersResponse>, GetUsersRequest, ResultFailure<Number, LeftNegativeInvalid| RightNegativeInvalid> | ResultFailure<String, UnknownError>, HttpConnection, User, User, String> = {
    name: "getUsersTriggerMultipleValuesMultipleErrorTypes",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsersMultipleValuesMultipleErrorType,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (triggerInput, connection) -> "1"
}

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var connection = defineBasicHttpConnectionProvider<@Label(value = "basic connection") {
    baseUri: @Label(value = "The base uri that will be used for all HTTP requests") String,
    user: @Label(value = "The username used to authenticate the requests") String,
    pass: @Label(value = "The password used to authenticate the requests") @SemanticTerms(value = ["password"]) String
}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

@TestConnector()
var connector = {
    name: "Errors",
    displayName: "Errors",
    connections: {basicAuth: connection},
    operations: {
       errorValueWithMultipleErrorTypes: errorValueWithMultipleErrorTypes,
       errorValueWithOneErrorType: errorValueWithOneErrorType,
       multipleErrorValuesWithMultipleErrorTypes: multipleErrorValuesWithMultipleErrorTypes
    },
    testConnection: testConnection,
    metadataProviders: {},
    valueProviders: {},
    triggers: {
        getUsersTriggerMultipleErrorTypes: getUsersTriggerMultipleErrorTypes,
        getUsersTriggerOneErrorTypes : getUsersTriggerOneErrorTypes,
        getUsersTriggerMultipleValuesMultipleErrorTypes: getUsersTriggerMultipleValuesMultipleErrorTypes
    }
}
