%dw 2.7

import slice from dw::core::Arrays

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::Trigger

type Account = { id: String}

@OperationElement
var operationElement : Operation<{value: String}, {id: Number, value: Number}, ResultFailure<{}, Error>, HttpConnection> = {
    name: "rootLevelDynamicFieldOperation",
    displayName: "rootLevelDynamicFieldOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

@OperationElement()
var getAccounts : Operation<{offset: Number, limit: Number}, HttpResponse<{items: Array<{id: String, name: String, email: String}>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getAccounts",
    displayName: "Get Accounts",
    executor: (parameter, connection) -> parameter.offset match {
            case "-1" -> do {
                    var response = {
                                    contentType: "application/json",
                                    status: 400,
                                    statusText: "Bad Request",
                                    headers: {},
                                    cookies: {},
                                    body: {}
                            }
                    ---
                    failure(response, response.body.detail)
                }

            else ->
success({
          contentType: "application/json",
          status: 200,
          headers: {},
          cookies: {},
          body: {
            items: slice([
              {
                id: "1",
                name: "One",
                email: "one@acme.com"
              },
              {
                id: "2",
                name: "Two",
                email: "two@acme.com"
              },
              {
                id: "3",
                name: "Three",
                email: "three@acme.com"
              },
              {
                id: "4",
                name: "Four",
                email: "four@acme.com"
              },
            ], parameter.offset, parameter.offset + parameter.limit)
          }
    })
            }
}

@OperationElement()
var getAccountsPaginated: PaginatedOperation<{offset: Number,limit: Number}, {offset: Number,limit: Number}, Page<Account,
  {offset: Number, limit: Number}>, ResultFailure<HttpResponse<Any>, Error>, HttpConnection> = (getAccounts paginated (param, page) -> {
    value: page,
    items: page.body.items default [],
    (nextPage: {
        args: param update { case offset at .offset -> offset + sizeOf(page.body.items) }
    }) if !isEmpty(page.body.items)
})

var operations = {
    "operationRef" : @OperationElement() operationElement,
    "undeclaredOperation" : operationElement,
    operationValue : @OperationElement() {
        name: "operationElement",
        displayName: "operationElement",
        executor: (parameter : {something: String}, connection : HttpConnection): Result<{id: Number, value: Number}, ResultFailure<{}, Error>> -> if (parameter.something?) success({id: 1, value: 2}) else failure({})
    },
    getAccounts: getAccountsPaginated
}


type GetUsersRequest = {since: Number}
type GetUsersResponse = {items: Array<User>}
type User = {id: String, name: String, email: String, created_at: Number}

var getUsers : Operation<GetUsersRequest, HttpResponse<GetUsersResponse>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) -> do {
        var response = connection({method: 'GET', path: "/users",queryParams: {since: parameter.since}})
        ---
        if (response.status == 200)
          success(response as HttpResponse<GetUsersResponse>)
        else
          failure(response)
    }
}

var myTriggerStrategy:TriggerStrategy<HttpResponse<GetUsersResponse>,User,User,Number> =
{
    items: (result) -> result.body.items,
    item: (item) -> item,
    watermark: (result,item) -> item.created_at,
    identity: (item) -> item.id as String,
    watermarkCompareTo: DefaultWatermarkComparison
}

@TriggerElement()
var getUsersTrigger: Trigger<GetUsersRequest, GetUsersRequest, HttpResponse<GetUsersResponse>, GetUsersRequest, ResultFailure<HttpResponse, Error>, HttpConnection,User, User, Number> = {
    name: "getUsersTrigger",
    displayName: "Get Users Trigger",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: myTriggerStrategy,
    operation: getUsers,
    inputMapper: (ti, w) -> ti,
    initialWatermark: (triggerInput, connection) -> 20200101
}
