%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var simpleConnection = {
    connect: defineHttpConnection(
        (parameter) -> parameter,
        (parameter) -> parameter,
        (a, b) -> b
    )
}

var getData : Operation<{}, Object, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getData",
    displayName: "Get Data",
    executor: (parameter, connection) -> success(
        {
            hello: "world"
        } <~ {mimeType: "application/json; charset=utf-8", raw: readUrl("classpath://streaming/some-data.json", "application/octet-stream") as Binary}
    ) as ResultSuccess<Object>
}

@TestConnector()
var connector = {
    name: "Stream",
    displayName: "Stream",
    connections: {simpleConnection: simpleConnection},
    operations: {
       calculateRoute: getData
    },
    testConnection: testConnection,
    metadataProviders: {},
}
