%dw 2.7

import * from dw::core::Arrays

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http

// ----------------
// -- Types --
// ----------------
type User = {
    userName: String,
    surname: String,
    age: Number
}
type GetUserByIdEndpointRequest = HttpRequestType<{|
  uri: { userId: Number },
  query: { metadata: String },
  headers: { customHeader: String },
  cookie: { cookie1: String, cookie2: String }
|}>

type GetUserByIdEndpointResponse = User & {metadata: {
    uri: GetUserByIdEndpointRequest.uri.userId,
    query: GetUserByIdEndpointRequest.query.metadata,
    headers: GetUserByIdEndpointRequest.headers.customHeader
}}

type GetUsersEndpointItemResponse = {id: String, name: String, email: String}
type GetUsersEndpointRequest = HttpRequestType<{|
  query: { offset?: Number, limit: Number },
  headers: {},
  cookie: {}
|}>
type GetUsersPaginatedEndpointRequest = HttpRequestType<{|
  query: { limit: Number },
  headers: {},
  cookie: {}
|}>
type GetUsersEndpointResponse = {items: Array<GetUsersEndpointItemResponse>}

// Connection

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
		isAlive,
		(response) -> { isValid: response.value.status == 200 }
	)
}

@ConnectionElement()
var connectionProvider = defineBasicHttpConnectionProvider<{baseUri: String, user: String, pass: String}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

// Operation
var getUserByIdEndpoint : HttpOperation<GetUserByIdEndpointRequest, GetUserByIdEndpointResponse, Any, HttpConnection> = {
  name: "getUserByIdEndpoint",
  displayName: "Get user by id",
  executor: (parameter, connection) ->
    success({
      contentType: "application/json",
      status: 200,
      headers: {},
      cookies: {},
      body: {
        userName: "Test user name",
        surname: "Test surname",
        age: 32,
        metadata:{
          uri: parameter.uri.userId,
          query: parameter.query.metadata,
          headers: parameter.headers.customHeader
        }
      }
  })
}

var allUsers = [
  {
    id: "1",
    name: "One",
    email: "one@acme.com"
  },
  {
    id: "2",
    name: "Two",
    email: "two@acme.com"
  },
  {
    id: "3",
    name: "Three",
    email: "three@acme.com"
  },
  {
    id: "4",
    name: "Four",
    email: "four@acme.com"
  },
  {
    id: "5",
    name: "Five",
    email: "five@acme.com"
  },
  {
    id: "6",
    name: "Six",
    email: "six@acme.com"
  }
]

@OperationElement()
var getUsers : HttpOperation<GetUsersEndpointRequest, GetUsersEndpointResponse, Any, HttpConnection> = {
    name: "getUsers",
    displayName: "Get Users",
    executor: (parameter, connection) ->
      success({
        contentType: "application/json",
        status: 200,
        headers: {},
        cookies: {},
        body: {
          items: slice(allUsers, parameter.query.offset default 0, (parameter.query.offset default 0) + parameter.query.limit)
        }
    })
}

var getUsersPaginated = (getUsers paginated (param, page) -> {
  items: page.body.items default [],
  (nextPage: {
      args: param update {
        case query at .query -> query update {
          case offset at .offset! -> (offset default 0) + sizeOf(page.body.items)
        }
      }
  }) if !isEmpty(page.body.items)
})

var getUsersPaginatedCustom = getUsersPaginated mapInputPaginatedOperation (param: GetUsersPaginatedEndpointRequest) -> {query: param.query, headers: param.headers, cookie: param.cookie}


//
// PAGINATED OPERATION WITH THE INPUT CHANGED AND A DIFFERENT NEXT OPERATION
//


// This represents the generated operation that cannot be changed but could be customized
@OperationElement()
var getUsers2 : HttpOperation<GetUsersEndpointRequest, GetUsersEndpointResponse, Any, HttpConnection> = {
    name: "getUsers2",
    displayName: "Get Users 2",
    executor: (parameter, connection) ->
      success({
        contentType: "application/json",
        status: 200,
        headers: {},
        cookies: {},
        body: {
          items: slice(allUsers, parameter.query.offset default 0, (parameter.query.offset default 0) + parameter.query.limit)
        }
    })
}

var getUsersWithoutOffset = getUsers2 mapInputOperation (param: GetUsersPaginatedEndpointRequest) -> {
  query: {
    offset: 0,
    limit: param.query.limit
  },
  headers: param.headers,
  cookie: param.cookie
}

var getUsersPaginatedWithDifferentSecondOperation =
  paginatedWithNextPageOp(getUsersWithoutOffset, getUsersPaginated, (param, page) -> {
    items: page.body.items default [],
    (nextPage: {
        args: param update {
            case query at .query -> query update {
                case offset at .offset! -> (offset default 0) + sizeOf(page.body.items)
              }
        }
    }) if !isEmpty(page.body.items)
  })
  mapInputPaginatedOperation (param: GetUsersPaginatedEndpointRequest) -> {query: param.query, headers: param.headers, cookie: param.cookie}
