/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.EagerPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class EagerPageTest {
    EagerPageTest() {
    }

    @Test
    public void basic() {
        String np = "NextPageData";
        EagerPage page1 = new EagerPage(List.of("One", "Two"), (Serializable)((Object)np));
        MatcherAssert.assertThat((Object)page1.getItems(), (Matcher)Matchers.hasItems((Object[])new String[]{"One", "Two"}));
        MatcherAssert.assertThat((Object)page1.getNextPage(), (Matcher)Matchers.is(Optional.of(np)));
        EagerPage page2 = new EagerPage(List.of("One", "Two"), null);
        MatcherAssert.assertThat((Object)page2.getNextPage(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)page1.toString(), (Matcher)Matchers.is((Object)"Page{items=[One, Two], nextPage=NextPageData}"));
        MatcherAssert.assertThat((Object)page2.toString(), (Matcher)Matchers.is((Object)"Page{items=[One, Two]}"));
        MatcherAssert.assertThat((Object)page1.equals(page1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)page1.equals(page2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)page1.equals(null), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)(page1.hashCode() != page2.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void builderFromNotPaginated() {
        Function fn = EagerPage.factory().getBuilderFunction(false, data -> "x" + String.valueOf(data));
        Page page = (Page)fn.apply(List.of("One", "Two"));
        MatcherAssert.assertThat((Object)page.getItems(), (Matcher)Matchers.hasItems((Object[])new String[]{"xOne", "xTwo"}));
        MatcherAssert.assertThat((Object)page.getNextPage(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void builderFromPaginated() {
        String np = "NextPageData";
        Function fn = EagerPage.factory().getBuilderFunction(true, data -> "x" + String.valueOf(data));
        EagerPage page = (EagerPage)fn.apply(Map.of("items", List.of("One", "Two"), "nextPage", np));
        MatcherAssert.assertThat((Object)page.getItems(), (Matcher)Matchers.hasItems((Object[])new Object[]{"xOne", "xTwo"}));
        MatcherAssert.assertThat((Object)page.getNextPage(), (Matcher)Matchers.is(Optional.of(np)));
    }
}

