/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api;

import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.ModelReferenceOperations;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;

public class DataWeaveObjectReference
extends DataWeaveReference<Map<?, ?>> {
    public DataWeaveObjectReference(String path, DWType type, Map<?, ?> value) {
        super(path, type, value);
    }

    public Optional<DataWeaveReference<?>> getProperty(String propertyName) {
        return TypeUtils.getObjectPropertyType(this.getType(), propertyName).flatMap(propertyType -> DataWeaveObjectReference.create(((Map)this.getValue()).get(propertyName), propertyType, ModelReferenceOperations.innerFieldReference(this.getPath(), propertyName)));
    }

    public DataWeaveReference<?> requireProperty(String propertyName) {
        return this.getProperty(propertyName).orElseThrow(() -> new InvalidConnectorException("A required property '" + propertyName + "' is missing.", this.lastLocation()));
    }

    private static Optional<DataWeaveReference<?>> create(@Nullable Object value, DWType propertyType, String propertyPath) {
        if (propertyType instanceof NullType) {
            return Optional.empty();
        }
        if (value instanceof Map || value == null && DataWeaveObjectReference.isObjectType(propertyType)) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new DataWeaveObjectReference(propertyPath, propertyType, (Map)value));
        }
        return value == null ? Optional.empty() : Optional.of(new DataWeaveReference<Object>(propertyPath, propertyType, value));
    }

    public Optional<DataWeaveObjectReference> getObjectProperty(String propertyName) {
        return this.getProperty(propertyName).map(z -> {
            if (!(z instanceof DataWeaveObjectReference)) {
                throw new InvalidConnectorException("The property '" + propertyName + "' was expected to be an object, but it's a " + z.getType().getClass().getSimpleName() + " instead.", z.getType().getLocation());
            }
            DataWeaveObjectReference o = (DataWeaveObjectReference)z;
            return o;
        });
    }

    public DataWeaveObjectReference requireObjectProperty(String propertyName) {
        return this.getObjectProperty(propertyName).orElseThrow(() -> new InvalidConnectorException("A required property '" + propertyName + "' is missing.", this.lastLocation()));
    }

    private static boolean isObjectType(DWType propertyType) {
        return propertyType instanceof ObjectType || propertyType instanceof IntersectionType || propertyType instanceof SimpleReferenceType && DataWeaveObjectReference.isObjectType(TypeUtils.resolveReferenceType(propertyType));
    }

    public void forEachProperty(BiConsumer<String, DataWeaveReference<?>> code) {
        this.properties().forEach(e -> code.accept((String)e.getKey(), (DataWeaveReference)e.getValue()));
    }

    public Stream<Map.Entry<String, ? extends DataWeaveReference<?>>> properties() {
        return ((Map)this.getValue()).keySet().stream().flatMap(o -> this.getProperty(o.toString()).map(p -> Map.entry(o.toString(), p)).stream());
    }

    public Location getPropertyLocation(String propertyName) {
        return TypeUtils.getObjectProperty(this.getType(), propertyName).map(p -> p.getKey().getLocation()).orElseThrow();
    }

    private @Nullable Location lastLocation() {
        return InvalidConnectorException.lastLocation(this.properties().map(p -> ((DataWeaveReference)p.getValue()).getType().getLocation()).toList()).orElse(null);
    }
}

