/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.internal.dataweave;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.model.values.BooleanValue;
import org.mule.weave.v2.model.values.NumberValue;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.LongNumber;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.runtime.ArrayDataWeaveValue;
import org.mule.weave.v2.runtime.DataWeaveNameValue;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ObjectDataWeaveValue;
import org.mule.weave.v2.runtime.SimpleDataWeaveValue;
import scala.Option;

class Converters {
    private Converters() {
    }

    static @Nullable Object toJava(@Nullable DataWeaveValue dataWeaveValue) {
        if (dataWeaveValue == null) {
            return null;
        }
        if (dataWeaveValue instanceof SimpleDataWeaveValue) {
            SimpleDataWeaveValue simple = (SimpleDataWeaveValue)dataWeaveValue;
            Object value = simple.value();
            if (value instanceof Number) {
                Number dwNumber = (Number)value;
                return Converters.toJava(dwNumber);
            }
            if (value instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)value;
                return charSequence.toString();
            }
            return value;
        }
        if (dataWeaveValue instanceof ObjectDataWeaveValue) {
            ObjectDataWeaveValue object = (ObjectDataWeaveValue)dataWeaveValue;
            return Converters.toJava(object.entries());
        }
        if (dataWeaveValue instanceof ArrayDataWeaveValue) {
            ArrayDataWeaveValue array = (ArrayDataWeaveValue)dataWeaveValue;
            return Arrays.stream(array.elements()).map(Converters::toJava).toList();
        }
        throw new IllegalArgumentException("Unsupported dataweave value: " + String.valueOf(dataWeaveValue));
    }

    private static Map<Object, Object> toJava(DataWeaveNameValue[] properties) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(properties.length);
        for (DataWeaveNameValue nv : properties) {
            Object value;
            String name = nv.name().getName();
            if (!keys.add(name) || (value = Converters.toJava(nv.value())) == null) continue;
            entries.add(Map.entry(name, value));
        }
        return Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new));
    }

    private static Object toJava(Number dwNumber) {
        java.lang.Number number = dwNumber.underlying();
        if (number instanceof Integer) {
            return number;
        }
        long n = number.longValue();
        return (n & 0xFFFFFFFFL) == n ? (java.lang.Number)((int)n) : (java.lang.Number)number;
    }

    static SimpleDataWeaveValue toDataWeaveValue(java.lang.Number num) {
        NumberValue.DefaultNumberValue value = new NumberValue.DefaultNumberValue((Number)new LongNumber(num.longValue()), null, Option.empty());
        return new SimpleDataWeaveValue((Value)value, null, null);
    }

    public static DataWeaveValue toDataWeaveValue(boolean b) {
        BooleanValue.DefaultBooleanValue value = new BooleanValue.DefaultBooleanValue(b, null, Option.empty());
        return new SimpleDataWeaveValue((Value)value, null, null);
    }
}

